/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.config.mapped;

import me.filoghost.chestcommands.fcommons.config.ConfigSection;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigLoadException;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigMappingException;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigSaveException;
import me.filoghost.chestcommands.fcommons.config.mapped.ConfigMapper;
import me.filoghost.chestcommands.fcommons.config.mapped.MappedConfig;
import me.filoghost.chestcommands.fcommons.reflection.TypeInfo;

public class BaseMappedConfigLoader<T extends MappedConfig> {
    private final TypeInfo<T> mappedTypeInfo;
    private ConfigMapper<T> configMapper;

    public BaseMappedConfigLoader(Class<T> mappedClass) {
        this.mappedTypeInfo = TypeInfo.of(mappedClass);
    }

    protected ConfigMapper<T> getMapper() throws ConfigMappingException {
        if (this.configMapper == null) {
            this.configMapper = new ConfigMapper<T>(this.mappedTypeInfo);
        }
        return this.configMapper;
    }

    public T loadFromConfig(ConfigSection configSection) throws ConfigLoadException {
        return this.loadFromConfig(configSection, null);
    }

    public T loadFromConfig(ConfigSection configSection, Object context) throws ConfigLoadException {
        try {
            MappedConfig mappedObject = (MappedConfig)this.getMapper().newMappedObjectInstance();
            this.getMapper().setFieldsFromConfig(mappedObject, configSection, context);
            return (T)mappedObject;
        }
        catch (ConfigMappingException e) {
            throw new ConfigLoadException(e.getMessage(), e.getCause());
        }
    }

    public void saveToConfig(T mappedObject, ConfigSection configSection) throws ConfigSaveException {
        try {
            this.getMapper().setConfigFromFields(mappedObject, configSection);
        }
        catch (ConfigMappingException e) {
            throw new ConfigSaveException(e.getMessage(), e.getCause());
        }
    }
}

