/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.config.mapped;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.filoghost.chestcommands.fcommons.config.ConfigErrors;
import me.filoghost.chestcommands.fcommons.config.ConfigSection;
import me.filoghost.chestcommands.fcommons.config.ConfigValue;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigMappingException;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigPostLoadException;
import me.filoghost.chestcommands.fcommons.config.mapped.ContextualPostLoadCallback;
import me.filoghost.chestcommands.fcommons.config.mapped.IncludeStatic;
import me.filoghost.chestcommands.fcommons.config.mapped.MappedField;
import me.filoghost.chestcommands.fcommons.config.mapped.MappingUtils;
import me.filoghost.chestcommands.fcommons.config.mapped.PostLoadCallback;
import me.filoghost.chestcommands.fcommons.reflection.ReflectionUtils;
import me.filoghost.chestcommands.fcommons.reflection.TypeInfo;

public class ConfigMapper<T> {
    private final TypeInfo<T> mappedTypeInfo;
    private final List<MappedField<?>> mappedFields;

    public ConfigMapper(TypeInfo<T> typeInfo) throws ConfigMappingException {
        try {
            this.mappedTypeInfo = typeInfo;
            ImmutableList.Builder mappedFieldsBuilder = ImmutableList.builder();
            for (Field field : ReflectionUtils.getDeclaredFields(typeInfo.getTypeClass())) {
                if (!this.isMappable(field)) continue;
                mappedFieldsBuilder.add(MappedField.of(field));
            }
            this.mappedFields = mappedFieldsBuilder.build();
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigMappingException(ConfigErrors.mapperReflectionException(typeInfo.getTypeClass()), e);
        }
    }

    public T newMappedObjectInstance() throws ConfigMappingException {
        return MappingUtils.createInstance(this.mappedTypeInfo);
    }

    public Map<String, ConfigValue> getFieldsAsConfigValues(T mappedObject) throws ConfigMappingException {
        LinkedHashMap<String, ConfigValue> configValues = new LinkedHashMap<String, ConfigValue>();
        for (MappedField<?> mappedField : this.mappedFields) {
            ConfigValue configValue = mappedField.readConfigValueFromObject(mappedObject);
            configValues.put(mappedField.getConfigPath(), configValue);
        }
        return configValues;
    }

    public void setConfigFromFields(T mappedObject, ConfigSection config) throws ConfigMappingException {
        for (MappedField<?> mappedField : this.mappedFields) {
            ConfigValue configValue = mappedField.readConfigValueFromObject(mappedObject);
            config.set(mappedField.getConfigPath(), configValue);
        }
    }

    public void setFieldsFromConfig(T mappedObject, ConfigSection config, Object context) throws ConfigMappingException, ConfigPostLoadException {
        for (MappedField<?> mappedField : this.mappedFields) {
            mappedField.setFieldValueFromConfig(mappedObject, config, context);
        }
        if (mappedObject instanceof PostLoadCallback) {
            ((PostLoadCallback)mappedObject).postLoad();
        }
        if (mappedObject instanceof ContextualPostLoadCallback) {
            ((ContextualPostLoadCallback)mappedObject).postLoad(context);
        }
    }

    private boolean isMappable(Field field) {
        int modifiers = field.getModifiers();
        boolean includeStatic = field.isAnnotationPresent(IncludeStatic.class) || field.getDeclaringClass().isAnnotationPresent(IncludeStatic.class);
        return !Modifier.isStatic(modifiers) || includeStatic || !Modifier.isTransient(modifiers) || !Modifier.isFinal(modifiers);
    }

    public boolean equalsConfig(T mappedObject, ConfigSection config) throws ConfigMappingException {
        for (MappedField<?> mappedField : this.mappedFields) {
            if (mappedField.equalsConfigValue(mappedObject, config)) continue;
            return false;
        }
        return true;
    }
}

