/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.config.mapped;

import com.google.common.collect.Lists;
import java.util.List;
import me.filoghost.chestcommands.fcommons.config.ConfigSection;
import me.filoghost.chestcommands.fcommons.config.ConfigValueType;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigMappingException;
import me.filoghost.chestcommands.fcommons.config.mapped.MappedConfigSection;
import me.filoghost.chestcommands.fcommons.config.mapped.converter.ConfigValueTypeConverter;
import me.filoghost.chestcommands.fcommons.config.mapped.converter.Converter;
import me.filoghost.chestcommands.fcommons.config.mapped.converter.ListConverter;
import me.filoghost.chestcommands.fcommons.config.mapped.converter.MappedConfigSectionConverter;
import me.filoghost.chestcommands.fcommons.reflection.TypeInfo;

public class ConverterRegistry {
    private static final List<ConfigValueTypeConverter<?>> CONFIG_VALUE_TYPE_CONVERTERS = Lists.newArrayList((Object[])new ConfigValueTypeConverter[]{new ConfigValueTypeConverter<Double>(ConfigValueType.DOUBLE, Double.class, Double.TYPE), new ConfigValueTypeConverter<Float>(ConfigValueType.FLOAT, Float.class, Float.TYPE), new ConfigValueTypeConverter<Long>(ConfigValueType.LONG, Long.class, Long.TYPE), new ConfigValueTypeConverter<Integer>(ConfigValueType.INTEGER, Integer.class, Integer.TYPE), new ConfigValueTypeConverter<Short>(ConfigValueType.SHORT, Short.class, Short.TYPE), new ConfigValueTypeConverter<Byte>(ConfigValueType.BYTE, Byte.class, Byte.TYPE), new ConfigValueTypeConverter<Boolean>(ConfigValueType.BOOLEAN, Boolean.class, Boolean.TYPE), new ConfigValueTypeConverter<String>(ConfigValueType.STRING, String.class), new ConfigValueTypeConverter<ConfigSection>(ConfigValueType.SECTION, ConfigSection.class)});

    public static <T> Converter<T, ?> create(TypeInfo<T> typeInfo) throws ConfigMappingException {
        Class<MappedConfigSection> typeClass = typeInfo.getTypeClass();
        for (ConfigValueTypeConverter<MappedConfigSection> configValueTypeConverter : CONFIG_VALUE_TYPE_CONVERTERS) {
            if (!configValueTypeConverter.supports(typeClass)) continue;
            return configValueTypeConverter;
        }
        if (MappedConfigSectionConverter.supports(typeClass)) {
            return new MappedConfigSectionConverter(typeInfo);
        }
        if (ListConverter.supports(typeClass)) {
            return new ListConverter(typeInfo);
        }
        throw new ConfigMappingException("cannot find suitable converter for class \"" + typeClass + "\"");
    }
}

