/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.config.mapped;

import java.nio.file.Path;
import java.util.Map;
import me.filoghost.chestcommands.fcommons.config.Config;
import me.filoghost.chestcommands.fcommons.config.ConfigLoader;
import me.filoghost.chestcommands.fcommons.config.ConfigSection;
import me.filoghost.chestcommands.fcommons.config.ConfigValue;
import me.filoghost.chestcommands.fcommons.config.FileConfig;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigLoadException;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigMappingException;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigSaveException;
import me.filoghost.chestcommands.fcommons.config.mapped.BaseMappedConfigLoader;
import me.filoghost.chestcommands.fcommons.config.mapped.MappedConfig;

public class MappedConfigLoader<T extends MappedConfig>
extends BaseMappedConfigLoader<T> {
    private final ConfigLoader configLoader;
    private Map<String, ConfigValue> defaultValues;

    public MappedConfigLoader(Path rootDataFolder, Path configPath, Class<T> mappedConfigClass) {
        super(mappedConfigClass);
        this.configLoader = new ConfigLoader(rootDataFolder, configPath);
    }

    public T load() throws ConfigLoadException {
        return this.load(null);
    }

    public T load(Object context) throws ConfigLoadException {
        FileConfig config = this.configLoader.load();
        return super.loadFromConfig(config, context);
    }

    public T init() throws ConfigLoadException, ConfigSaveException {
        return this.init(null);
    }

    public T init(Object context) throws ConfigLoadException, ConfigSaveException {
        FileConfig config = this.configLoader.init();
        try {
            boolean modified;
            MappedConfig mappedObject = (MappedConfig)this.getMapper().newMappedObjectInstance();
            if (this.defaultValues == null) {
                this.defaultValues = this.getMapper().getFieldsAsConfigValues(mappedObject);
            }
            if (modified = this.addMissingDefaultValues(config, this.defaultValues)) {
                config.setHeader(mappedObject.getHeader());
                this.configLoader.save(config);
            }
            this.getMapper().setFieldsFromConfig(mappedObject, config, context);
            return (T)mappedObject;
        }
        catch (ConfigMappingException e) {
            throw new ConfigLoadException(e.getMessage(), e.getCause());
        }
    }

    private boolean addMissingDefaultValues(ConfigSection config, Map<String, ConfigValue> defaultValues) {
        boolean modified = false;
        for (Map.Entry<String, ConfigValue> entry : defaultValues.entrySet()) {
            if (config.contains(entry.getKey())) continue;
            config.set(entry.getKey(), entry.getValue());
            modified = true;
        }
        return modified;
    }

    public void save(T mappedObject) throws ConfigSaveException {
        Config config = new Config();
        this.saveWithHeader(config, mappedObject);
    }

    public boolean saveIfDifferent(T newMappedObject) throws ConfigLoadException, ConfigSaveException {
        if (!this.configLoader.fileExists()) {
            this.saveWithHeader(new Config(), newMappedObject);
            return true;
        }
        FileConfig config = this.configLoader.load();
        try {
            if (!this.getMapper().equalsConfig(newMappedObject, config)) {
                this.saveWithHeader(config, newMappedObject);
                return true;
            }
        }
        catch (ConfigMappingException e) {
            throw new ConfigLoadException(e.getMessage(), e.getCause());
        }
        return false;
    }

    private void saveWithHeader(Config config, T mappedObject) throws ConfigSaveException {
        super.saveToConfig(mappedObject, config);
        config.setHeader(mappedObject.getHeader());
        this.configLoader.save(config);
    }

    public Path getFile() {
        return this.configLoader.getFile();
    }
}

