/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.config.mapped;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.filoghost.chestcommands.fcommons.config.ConfigErrors;
import me.filoghost.chestcommands.fcommons.config.ConfigSection;
import me.filoghost.chestcommands.fcommons.config.ConfigValue;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigMappingException;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigPostLoadException;
import me.filoghost.chestcommands.fcommons.config.mapped.ConverterRegistry;
import me.filoghost.chestcommands.fcommons.config.mapped.converter.Converter;
import me.filoghost.chestcommands.fcommons.config.mapped.modifier.ChatColorsModifier;
import me.filoghost.chestcommands.fcommons.config.mapped.modifier.ValueModifier;
import me.filoghost.chestcommands.fcommons.reflection.ReflectionUtils;
import me.filoghost.chestcommands.fcommons.reflection.TypeInfo;

public class MappedField<T> {
    private static final List<ValueModifier<?, ?>> VALUE_MODIFIERS = ImmutableList.of((Object)new ChatColorsModifier());
    private final TypeInfo<T> typeInfo;
    private final Field field;
    private final Converter<T, ?> converter;
    private final String configPath;
    private final List<Annotation> annotations;

    public static MappedField<?> of(Field field) throws ReflectiveOperationException, ConfigMappingException {
        return new MappedField(TypeInfo.of(field), field);
    }

    private MappedField(TypeInfo<T> typeInfo, Field field) throws ConfigMappingException {
        this.typeInfo = typeInfo;
        this.field = field;
        this.converter = ConverterRegistry.create(typeInfo);
        this.configPath = field.getName().replace("__", ".").replace("_", "-");
        this.annotations = Stream.concat(Arrays.stream(field.getDeclaredAnnotations()), Arrays.stream(field.getDeclaringClass().getDeclaredAnnotations())).collect(Collectors.toList());
    }

    public boolean equalsConfigValue(Object mappedObject, ConfigSection config) throws ConfigMappingException {
        T fieldValue = this.readFromObject(mappedObject);
        ConfigValue configValue = config.get(this.configPath);
        return this.converter.equalsConfig(fieldValue, configValue);
    }

    public ConfigValue readConfigValueFromObject(Object mappedObject) throws ConfigMappingException {
        try {
            T fieldValue = this.readFromObject(mappedObject);
            if (fieldValue != null) {
                return this.converter.toConfigValue(fieldValue);
            }
            return ConfigValue.NULL;
        }
        catch (ConfigMappingException e) {
            throw new ConfigMappingException(ConfigErrors.conversionFailed(this), e);
        }
    }

    public void setFieldValueFromConfig(Object mappedObject, ConfigSection config, Object context) throws ConfigMappingException, ConfigPostLoadException {
        ConfigValue configValue = config.get(this.configPath);
        if (configValue == null) {
            return;
        }
        try {
            T fieldValue = this.converter.toFieldValue(configValue, context);
            if (fieldValue == null) {
                return;
            }
            for (Annotation annotation : this.annotations) {
                fieldValue = this.applyValueModifiers(fieldValue, annotation);
            }
            this.writeToObject(mappedObject, fieldValue);
        }
        catch (ConfigMappingException e) {
            throw new ConfigMappingException(ConfigErrors.conversionFailed(this), e);
        }
    }

    private T readFromObject(Object mappedObject) throws ConfigMappingException {
        try {
            return this.typeInfo.cast(ReflectionUtils.getFieldValue(this.field, mappedObject));
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigMappingException(ConfigErrors.fieldReadError(this), e);
        }
    }

    private void writeToObject(Object mappedObject, T fieldValue) throws ConfigMappingException {
        try {
            ReflectionUtils.setFieldValue(this.field, mappedObject, fieldValue);
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigMappingException(ConfigErrors.fieldWriteError(this), e);
        }
    }

    private <F, A extends Annotation> F applyValueModifiers(F fieldValue, A annotation) {
        for (ValueModifier<?, ?> modifier : VALUE_MODIFIERS) {
            if (!modifier.isApplicable(annotation, fieldValue)) continue;
            fieldValue = modifier.transform(annotation, fieldValue);
        }
        return fieldValue;
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public String getConfigPath() {
        return this.configPath;
    }
}

