/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.config.mapped.converter;

import me.filoghost.chestcommands.fcommons.config.ConfigValue;
import me.filoghost.chestcommands.fcommons.config.ConfigValueType;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigMappingException;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigPostLoadException;

public abstract class Converter<F, V> {
    protected final ConfigValueType<V> configValueType;

    protected Converter(ConfigValueType<V> configValueType) {
        this.configValueType = configValueType;
    }

    public final ConfigValue toConfigValue(F fieldValue) throws ConfigMappingException {
        V configValue = this.toConfigValue0(fieldValue);
        if (configValue != null) {
            return ConfigValue.of(this.configValueType, configValue);
        }
        return ConfigValue.NULL;
    }

    protected abstract V toConfigValue0(F var1) throws ConfigMappingException;

    public final F toFieldValue(ConfigValue configValue, Object context) throws ConfigMappingException, ConfigPostLoadException {
        V rawConfigValue = configValue.as(this.configValueType);
        if (rawConfigValue != null) {
            return this.toFieldValue0(rawConfigValue, context);
        }
        return null;
    }

    protected abstract F toFieldValue0(V var1, Object var2) throws ConfigMappingException, ConfigPostLoadException;

    public final boolean equalsConfig(F fieldValue, ConfigValue configValue) throws ConfigMappingException {
        V rawConfigValue = configValue.as(this.configValueType);
        return this.equalsConfig0(fieldValue, rawConfigValue);
    }

    protected abstract boolean equalsConfig0(F var1, V var2) throws ConfigMappingException;
}

