/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.config.mapped.converter;

import java.util.ArrayList;
import java.util.List;
import me.filoghost.chestcommands.fcommons.config.ConfigValue;
import me.filoghost.chestcommands.fcommons.config.ConfigValueType;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigMappingException;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigPostLoadException;
import me.filoghost.chestcommands.fcommons.config.mapped.ConverterRegistry;
import me.filoghost.chestcommands.fcommons.config.mapped.MappingUtils;
import me.filoghost.chestcommands.fcommons.config.mapped.converter.Converter;
import me.filoghost.chestcommands.fcommons.reflection.TypeInfo;

public class ListConverter<E>
extends Converter<List<E>, List<ConfigValue>> {
    protected final TypeInfo<List<E>> fieldTypeInfo;
    private final Converter<E, ?> elementConverter;

    public ListConverter(TypeInfo<List<E>> fieldTypeInfo) throws ConfigMappingException {
        super(ConfigValueType.LIST);
        this.fieldTypeInfo = fieldTypeInfo;
        TypeInfo<?> elementTypeInfo = MappingUtils.getSingleGenericType(fieldTypeInfo);
        this.elementConverter = ConverterRegistry.create(elementTypeInfo);
    }

    @Override
    protected List<ConfigValue> toConfigValue0(List<E> fieldValue) throws ConfigMappingException {
        ArrayList<ConfigValue> configList = new ArrayList<ConfigValue>();
        for (E fieldElement : fieldValue) {
            configList.add(this.elementConverter.toConfigValue(fieldElement));
        }
        return configList;
    }

    @Override
    protected List<E> toFieldValue0(List<ConfigValue> configList, Object context) throws ConfigMappingException, ConfigPostLoadException {
        ArrayList<E> fieldList = new ArrayList<E>();
        for (ConfigValue configElement : configList) {
            if (!this.isValidConfigListElement(configElement)) continue;
            E fieldValue = this.elementConverter.toFieldValue(configElement, context);
            fieldList.add(fieldValue);
        }
        return fieldList;
    }

    @Override
    protected boolean equalsConfig0(List<E> fieldList, List<ConfigValue> configList) throws ConfigMappingException {
        if (fieldList == null && configList == null) {
            return true;
        }
        if (fieldList == null || configList == null) {
            return false;
        }
        ArrayList<ConfigValue> filteredConfigList = new ArrayList<ConfigValue>();
        for (ConfigValue configValue : configList) {
            if (!this.isValidConfigListElement(configValue)) continue;
            filteredConfigList.add(configValue);
        }
        if (filteredConfigList.size() != fieldList.size()) {
            return false;
        }
        for (int i = 0; i < filteredConfigList.size(); ++i) {
            ConfigValue configElement = (ConfigValue)filteredConfigList.get(i);
            E fieldElement = fieldList.get(i);
            if (this.elementConverter.equalsConfig(fieldElement, configElement)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidConfigListElement(ConfigValue configElement) {
        return configElement.isPresentAs(this.elementConverter.configValueType);
    }

    public static boolean supports(Class<?> clazz) {
        return clazz == List.class;
    }
}

