/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.config.valuetype;

import java.util.ArrayList;
import java.util.List;
import me.filoghost.chestcommands.fcommons.config.ConfigValueType;

public class ListConfigValueType<E>
extends ConfigValueType<List<E>> {
    private final ConfigValueType<E> elementType;

    public ListConfigValueType(String name, ConfigValueType<E> elementType) {
        super(name, "value is not a list");
        this.elementType = elementType;
    }

    @Override
    protected boolean isValidConfigValue(Object value) {
        return value instanceof List;
    }

    @Override
    protected List<E> fromConfigValue(Object value) {
        ArrayList<E> result = new ArrayList<E>();
        for (Object element : (List)value) {
            E convertedElement = ListConfigValueType.fromConfigValueOrNull(this.elementType, element);
            if (convertedElement == null) continue;
            result.add(convertedElement);
        }
        return result;
    }

    @Override
    protected Object toConfigValue(List<E> value) {
        return value;
    }
}

