/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public class ReflectionUtils {
    public static Object getFieldValue(Field field, Object instance) throws ReflectiveOperationException {
        try {
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (ReflectiveOperationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ReflectiveOperationException(t);
        }
    }

    public static void setFieldValue(Field field, Object instance, Object value) throws ReflectiveOperationException {
        try {
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (ReflectiveOperationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ReflectiveOperationException(t);
        }
    }

    public static void setFinalFieldValue(Field field, Object instance, Object value) throws ReflectiveOperationException {
        try {
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(instance, value);
        }
        catch (ReflectiveOperationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ReflectiveOperationException(t);
        }
    }

    public static boolean isClassLoaded(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static Field[] getDeclaredFields(Class<?> clazz) throws ReflectiveOperationException {
        try {
            return clazz.getDeclaredFields();
        }
        catch (Throwable t) {
            throw new ReflectiveOperationException(t);
        }
    }

    public static <T> T newInstance(Class<T> clazz) throws ReflectiveOperationException {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ReflectiveOperationException(t);
        }
    }

    public static <T> Class<T> wrapPrimitiveClass(Class<T> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Double.TYPE) {
                return Double.class;
            }
            if (clazz == Float.TYPE) {
                return Float.class;
            }
            if (clazz == Long.TYPE) {
                return Long.class;
            }
            if (clazz == Integer.TYPE) {
                return Integer.class;
            }
            if (clazz == Short.TYPE) {
                return Short.class;
            }
            if (clazz == Byte.TYPE) {
                return Byte.class;
            }
            if (clazz == Character.TYPE) {
                return Character.class;
            }
            if (clazz == Boolean.TYPE) {
                return Boolean.class;
            }
            if (clazz == Void.TYPE) {
                return Void.class;
            }
        }
        return clazz;
    }
}

