/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.fcommons.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.stream.Collectors;
import me.filoghost.chestcommands.fcommons.Preconditions;
import me.filoghost.chestcommands.fcommons.reflection.ReflectionUtils;

public class TypeInfo<T> {
    private final Class<T> typeClass;
    private final Type[] typeArguments;

    public TypeInfo(Class<T> typeClass, Type ... typeArguments) {
        this.typeClass = ReflectionUtils.wrapPrimitiveClass(typeClass);
        this.typeArguments = typeArguments;
    }

    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    public Type[] getTypeArguments() {
        return this.typeArguments;
    }

    public T cast(Object object) {
        return this.typeClass.cast(object);
    }

    public static TypeInfo<?> of(Field field) throws ReflectiveOperationException {
        Type genericType;
        Preconditions.notNull(field, "field");
        try {
            genericType = field.getGenericType();
        }
        catch (Throwable t) {
            throw new ReflectiveOperationException(t);
        }
        return TypeInfo.of(genericType);
    }

    public static <T> TypeInfo<T> of(Class<T> clazz) {
        return new TypeInfo<T>(clazz, new Type[0]);
    }

    public static TypeInfo<?> of(Type type) throws ReflectiveOperationException {
        Preconditions.notNull(type, "type");
        try {
            Type[] typeArguments;
            Class typeClass;
            if (type instanceof Class) {
                typeClass = (Class)type;
                typeArguments = null;
            } else if (type instanceof ParameterizedType) {
                typeClass = (Class)((ParameterizedType)type).getRawType();
                typeArguments = ((ParameterizedType)type).getActualTypeArguments();
            } else {
                throw new ReflectiveOperationException("type is not a Class or ParameterizedType");
            }
            return new TypeInfo(typeClass, typeArguments);
        }
        catch (Throwable t) {
            throw new ReflectiveOperationException(t);
        }
    }

    public String toString() {
        String output = this.typeClass.toString();
        if (this.typeArguments != null && this.typeArguments.length > 0) {
            output = output + Arrays.stream(this.typeArguments).map(Object::toString).collect(Collectors.joining(", ", "<", ">"));
        }
        return output;
    }
}

