/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.hook;

import me.filoghost.chestcommands.fcommons.Preconditions;
import me.filoghost.chestcommands.hook.PluginHook;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public enum VaultEconomyHook implements PluginHook
{
    INSTANCE;

    private Economy economy;

    @Override
    public void setup() {
        this.economy = null;
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            return;
        }
        RegisteredServiceProvider economyServiceProvider = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (economyServiceProvider == null) {
            return;
        }
        this.economy = (Economy)economyServiceProvider.getProvider();
    }

    @Override
    public boolean isEnabled() {
        return this.economy != null;
    }

    public static double getMoney(Player player) {
        INSTANCE.checkEnabledState();
        return VaultEconomyHook.INSTANCE.economy.getBalance((OfflinePlayer)player, player.getWorld().getName());
    }

    public static boolean hasMoney(Player player, double minimum) {
        INSTANCE.checkEnabledState();
        VaultEconomyHook.checkPositiveAmount(minimum);
        double balance = VaultEconomyHook.INSTANCE.economy.getBalance((OfflinePlayer)player, player.getWorld().getName());
        return balance >= minimum;
    }

    public static boolean takeMoney(Player player, double amount) {
        INSTANCE.checkEnabledState();
        VaultEconomyHook.checkPositiveAmount(amount);
        EconomyResponse response = VaultEconomyHook.INSTANCE.economy.withdrawPlayer((OfflinePlayer)player, player.getWorld().getName(), amount);
        return response.transactionSuccess();
    }

    public static boolean giveMoney(Player player, double amount) {
        INSTANCE.checkEnabledState();
        VaultEconomyHook.checkPositiveAmount(amount);
        EconomyResponse response = VaultEconomyHook.INSTANCE.economy.depositPlayer((OfflinePlayer)player, player.getWorld().getName(), amount);
        return response.transactionSuccess();
    }

    private static void checkPositiveAmount(double amount) {
        Preconditions.checkArgument(amount >= 0.0, "amount cannot be negative");
    }

    public static String formatMoney(double amount) {
        if (VaultEconomyHook.INSTANCE.economy != null) {
            return VaultEconomyHook.INSTANCE.economy.format(amount);
        }
        return Double.toString(amount);
    }
}

