/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.icon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.filoghost.chestcommands.api.Icon;
import me.filoghost.chestcommands.fcommons.Preconditions;
import me.filoghost.chestcommands.fcommons.collection.CollectionUtils;
import me.filoghost.chestcommands.placeholder.PlaceholderString;
import me.filoghost.chestcommands.placeholder.PlaceholderStringList;
import me.filoghost.chestcommands.util.nbt.parser.MojangsonParseException;
import me.filoghost.chestcommands.util.nbt.parser.MojangsonParser;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseConfigurableIcon
implements Icon {
    private Material material;
    private int amount;
    private short durability;
    private String nbtData;
    private PlaceholderString name;
    private PlaceholderStringList lore;
    private Map<Enchantment, Integer> enchantments;
    private Color leatherColor;
    private PlaceholderString skullOwner;
    private DyeColor bannerColor;
    private List<Pattern> bannerPatterns;
    private boolean placeholdersEnabled;
    private ItemStack cachedRendering;

    public BaseConfigurableIcon(Material material) {
        this.material = material;
        this.amount = 1;
    }

    protected boolean shouldCacheRendering() {
        return !this.placeholdersEnabled || !this.hasDynamicPlaceholders();
    }

    private boolean hasDynamicPlaceholders() {
        return this.name != null && this.name.hasDynamicPlaceholders() || this.lore != null && this.lore.hasDynamicPlaceholders() || this.skullOwner != null && this.skullOwner.hasDynamicPlaceholders();
    }

    public void setMaterial(@NotNull Material material) {
        this.material = material;
        this.cachedRendering = null;
    }

    @NotNull
    public Material getMaterial() {
        return this.material;
    }

    public void setAmount(int amount) {
        Preconditions.checkArgument(amount > 0, "amount must be greater than 0");
        this.amount = Math.min(amount, 127);
        this.cachedRendering = null;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setDurability(short durability) {
        Preconditions.checkArgument(durability >= 0, "durability must be 0 or greater");
        this.durability = durability;
        this.cachedRendering = null;
    }

    public short getDurability() {
        return this.durability;
    }

    public void setNBTData(@Nullable String nbtData) {
        if (nbtData != null) {
            try {
                MojangsonParser.parse(nbtData);
            }
            catch (MojangsonParseException e) {
                throw new IllegalArgumentException("invalid nbtData", e);
            }
        }
        this.nbtData = nbtData;
        this.cachedRendering = null;
    }

    @Nullable
    public String getNBTData() {
        return this.nbtData;
    }

    public void setName(@Nullable String name) {
        this.name = PlaceholderString.of(name);
        this.cachedRendering = null;
    }

    @Nullable
    public String getName() {
        if (this.name != null) {
            return this.name.getOriginalValue();
        }
        return null;
    }

    public void setLore(String ... lore) {
        this.setLore(lore != null ? Arrays.asList(lore) : null);
    }

    public void setLore(@Nullable List<String> lore) {
        this.lore = lore != null ? new PlaceholderStringList(CollectionUtils.replaceNulls(lore, "")) : null;
        this.cachedRendering = null;
    }

    @Nullable
    public List<String> getLore() {
        if (this.lore != null) {
            return new ArrayList<String>((Collection<String>)this.lore.getOriginalValue());
        }
        return null;
    }

    public void setEnchantments(@Nullable Map<Enchantment, Integer> enchantments) {
        this.enchantments = CollectionUtils.copy(enchantments);
        this.cachedRendering = null;
    }

    @Nullable
    public Map<Enchantment, Integer> getEnchantments() {
        return CollectionUtils.copy(this.enchantments);
    }

    public void addEnchantment(@NotNull Enchantment enchantment) {
        this.addEnchantment(enchantment, 1);
    }

    public void addEnchantment(@NotNull Enchantment enchantment, int level) {
        if (this.enchantments == null) {
            this.enchantments = new HashMap<Enchantment, Integer>();
        }
        this.enchantments.put(enchantment, level);
        this.cachedRendering = null;
    }

    public void removeEnchantment(@NotNull Enchantment enchantment) {
        if (this.enchantments == null) {
            return;
        }
        this.enchantments.remove(enchantment);
        this.cachedRendering = null;
    }

    @Nullable
    public Color getLeatherColor() {
        return this.leatherColor;
    }

    public void setLeatherColor(@Nullable Color leatherColor) {
        this.leatherColor = leatherColor;
        this.cachedRendering = null;
    }

    @Nullable
    public String getSkullOwner() {
        if (this.skullOwner != null) {
            return this.skullOwner.getOriginalValue();
        }
        return null;
    }

    public void setSkullOwner(@Nullable String skullOwner) {
        this.skullOwner = PlaceholderString.of(skullOwner);
        this.cachedRendering = null;
    }

    @Nullable
    public DyeColor getBannerColor() {
        return this.bannerColor;
    }

    public void setBannerColor(@Nullable DyeColor bannerColor) {
        this.bannerColor = bannerColor;
        this.cachedRendering = null;
    }

    @Nullable
    public List<Pattern> getBannerPatterns() {
        return CollectionUtils.copy(this.bannerPatterns);
    }

    public void setBannerPatterns(Pattern ... bannerPatterns) {
        this.setBannerPatterns(bannerPatterns != null ? Arrays.asList(bannerPatterns) : null);
    }

    public void setBannerPatterns(@Nullable List<Pattern> bannerPatterns) {
        this.bannerPatterns = CollectionUtils.copy(bannerPatterns);
        this.cachedRendering = null;
    }

    public boolean isPlaceholdersEnabled() {
        return this.placeholdersEnabled;
    }

    public void setPlaceholdersEnabled(boolean placeholdersEnabled) {
        this.placeholdersEnabled = placeholdersEnabled;
        this.cachedRendering = null;
    }

    @Nullable
    public String renderName(Player viewer) {
        if (this.name == null) {
            return null;
        }
        if (!this.placeholdersEnabled) {
            return this.name.getOriginalValue();
        }
        String name = this.name.getValue(viewer);
        if (name.isEmpty()) {
            return ChatColor.WHITE.toString();
        }
        return name;
    }

    @Nullable
    public List<String> renderLore(Player viewer) {
        if (this.lore == null) {
            return null;
        }
        if (!this.placeholdersEnabled) {
            return this.lore.getOriginalValue();
        }
        return this.lore.getValue(viewer);
    }

    @Override
    public ItemStack render(@NotNull Player viewer) {
        ItemMeta itemMeta;
        if (this.shouldCacheRendering() && this.cachedRendering != null) {
            return this.cachedRendering;
        }
        ItemStack itemStack = new ItemStack(this.material, this.amount, this.durability);
        if (this.nbtData != null) {
            Bukkit.getUnsafe().modifyItemStack(itemStack, this.nbtData);
        }
        if ((itemMeta = itemStack.getItemMeta()) != null) {
            itemMeta.setDisplayName(this.renderName(viewer));
            itemMeta.setLore(this.renderLore(viewer));
            if (this.leatherColor != null && itemMeta instanceof LeatherArmorMeta) {
                ((LeatherArmorMeta)itemMeta).setColor(this.leatherColor);
            }
            if (this.skullOwner != null && itemMeta instanceof SkullMeta) {
                String skullOwner = this.skullOwner.getValue(viewer);
                ((SkullMeta)itemMeta).setOwner(skullOwner);
            }
            if (itemMeta instanceof BannerMeta) {
                BannerMeta bannerMeta = (BannerMeta)itemMeta;
                if (this.bannerColor != null) {
                    bannerMeta.setBaseColor(this.bannerColor);
                }
                if (this.bannerPatterns != null) {
                    ((BannerMeta)itemMeta).setPatterns(this.bannerPatterns);
                }
            }
            if (itemMeta.getItemFlags().isEmpty()) {
                itemMeta.addItemFlags(ItemFlag.values());
            }
            itemStack.setItemMeta(itemMeta);
        }
        if (this.enchantments != null) {
            this.enchantments.forEach((arg_0, arg_1) -> ((ItemStack)itemStack).addUnsafeEnchantment(arg_0, arg_1));
        }
        if (this.shouldCacheRendering()) {
            this.cachedRendering = itemStack;
        }
        return itemStack;
    }
}

