/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.icon;

import me.filoghost.chestcommands.fcommons.Strings;
import org.bukkit.entity.Player;

public class IconPermission {
    private final String permission;
    private final boolean negated;

    public IconPermission(String permission) {
        if (permission != null) {
            permission = permission.trim();
        }
        if (Strings.isEmpty(permission)) {
            this.permission = null;
            this.negated = false;
        } else if (permission.startsWith("-")) {
            this.permission = permission.substring(1);
            this.negated = true;
        } else {
            this.permission = permission;
            this.negated = false;
        }
    }

    private boolean hasPermission(Player player) {
        if (this.isEmpty()) {
            return true;
        }
        if (this.negated) {
            return !player.hasPermission(this.permission);
        }
        return player.hasPermission(this.permission);
    }

    public boolean isEmpty() {
        return this.permission == null;
    }

    public static boolean hasPermission(Player player, IconPermission permission) {
        return permission == null || permission.hasPermission(player);
    }
}

