/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.icon;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.filoghost.chestcommands.action.Action;
import me.filoghost.chestcommands.action.OpenMenuAction;
import me.filoghost.chestcommands.api.MenuView;
import me.filoghost.chestcommands.config.Lang;
import me.filoghost.chestcommands.fcommons.Preconditions;
import me.filoghost.chestcommands.fcommons.collection.CollectionUtils;
import me.filoghost.chestcommands.icon.BaseConfigurableIcon;
import me.filoghost.chestcommands.icon.ClickResult;
import me.filoghost.chestcommands.icon.IconPermission;
import me.filoghost.chestcommands.icon.RefreshableIcon;
import me.filoghost.chestcommands.icon.requirement.RequiredExpLevel;
import me.filoghost.chestcommands.icon.requirement.RequiredMoney;
import me.filoghost.chestcommands.icon.requirement.Requirement;
import me.filoghost.chestcommands.icon.requirement.item.RequiredItem;
import me.filoghost.chestcommands.icon.requirement.item.RequiredItems;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternalConfigurableIcon
extends BaseConfigurableIcon
implements RefreshableIcon {
    private IconPermission viewPermission;
    private IconPermission clickPermission;
    private String noClickPermissionMessage;
    private RequiredMoney requiredMoney;
    private RequiredExpLevel requiredExpLevel;
    private RequiredItems requiredItems;
    private ImmutableList<Action> clickActions;
    private ClickResult clickResult;

    public InternalConfigurableIcon(Material material) {
        super(material);
        this.setPlaceholdersEnabled(true);
        this.clickResult = ClickResult.CLOSE;
    }

    public boolean canViewIcon(Player player) {
        return IconPermission.hasPermission(player, this.viewPermission);
    }

    public boolean hasViewPermission() {
        return this.viewPermission != null && !this.viewPermission.isEmpty();
    }

    public void setClickPermission(String permission) {
        this.clickPermission = new IconPermission(permission);
    }

    public void setNoClickPermissionMessage(String noClickPermissionMessage) {
        this.noClickPermissionMessage = noClickPermissionMessage;
    }

    public void setViewPermission(String viewPermission) {
        this.viewPermission = new IconPermission(viewPermission);
    }

    public void setRequiredMoney(double requiredMoney) {
        this.requiredMoney = requiredMoney > 0.0 ? new RequiredMoney(requiredMoney) : null;
    }

    public void setRequiredExpLevel(int requiredLevels) {
        this.requiredExpLevel = requiredLevels > 0 ? new RequiredExpLevel(requiredLevels) : null;
    }

    public void setRequiredItems(List<RequiredItem> requiredItems) {
        this.requiredItems = requiredItems != null ? new RequiredItems(requiredItems) : null;
    }

    public void setClickActions(List<Action> clickActions) {
        this.clickActions = CollectionUtils.immutableCopy(clickActions);
    }

    @Override
    public ItemStack render(@NotNull Player viewer) {
        if (this.canViewIcon(viewer)) {
            return super.render(viewer);
        }
        return null;
    }

    @Override
    protected boolean shouldCacheRendering() {
        return super.shouldCacheRendering() && !this.hasViewPermission();
    }

    public void setClickResult(ClickResult clickResult) {
        Preconditions.notNull((Object)clickResult, "clickResult");
        this.clickResult = clickResult;
    }

    @Override
    public void onClick(@NotNull MenuView menuView, @NotNull Player player) {
        ClickResult clickResult = this.onClickGetResult(menuView, player);
        if (clickResult == ClickResult.CLOSE) {
            menuView.close();
        }
    }

    private ClickResult onClickGetResult(@NotNull MenuView menuView, @NotNull Player player) {
        if (!IconPermission.hasPermission(player, this.viewPermission)) {
            return ClickResult.KEEP_OPEN;
        }
        if (!IconPermission.hasPermission(player, this.clickPermission)) {
            if (this.noClickPermissionMessage != null) {
                player.sendMessage(this.noClickPermissionMessage);
            } else {
                player.sendMessage(Lang.default_no_icon_permission);
            }
            return this.clickResult;
        }
        Requirement[] requirements = new Requirement[]{this.requiredMoney, this.requiredExpLevel, this.requiredItems};
        boolean hasAllRequirements = Requirement.hasAllCosts(player, requirements);
        if (!hasAllRequirements) {
            return this.clickResult;
        }
        boolean takenAllCosts = Requirement.takeAllCosts(player, requirements);
        if (!takenAllCosts) {
            return this.clickResult;
        }
        boolean hasOpenMenuAction = false;
        if (this.clickActions != null) {
            for (Action action : this.clickActions) {
                action.execute(player);
                if (!(action instanceof OpenMenuAction)) continue;
                hasOpenMenuAction = true;
            }
        }
        menuView.refresh();
        if (hasOpenMenuAction) {
            return ClickResult.KEEP_OPEN;
        }
        return this.clickResult;
    }

    @Override
    @Nullable
    public ItemStack updateRendering(Player viewer, @Nullable ItemStack currentRendering) {
        if (currentRendering != null && this.shouldCacheRendering()) {
            return currentRendering;
        }
        if (!this.canViewIcon(viewer)) {
            return null;
        }
        if (currentRendering == null) {
            return this.render(viewer);
        }
        ItemMeta meta = currentRendering.getItemMeta();
        meta.setDisplayName(this.renderName(viewer));
        meta.setLore(this.renderLore(viewer));
        currentRendering.setItemMeta(meta);
        return currentRendering;
    }
}

