/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.icon.requirement;

import com.google.common.base.Preconditions;
import me.filoghost.chestcommands.config.Lang;
import me.filoghost.chestcommands.icon.requirement.Requirement;
import org.bukkit.entity.Player;

public class RequiredExpLevel
implements Requirement {
    private final int levels;

    public RequiredExpLevel(int levels) {
        Preconditions.checkArgument((levels > 0 ? 1 : 0) != 0, (Object)"levels must be positive");
        this.levels = levels;
    }

    @Override
    public boolean hasCost(Player player) {
        if (player.getLevel() < this.levels) {
            player.sendMessage(Lang.no_exp.replace("{levels}", Integer.toString(this.levels)));
            return false;
        }
        return true;
    }

    @Override
    public boolean takeCost(Player player) {
        int newLevel = player.getLevel() - this.levels;
        if (newLevel < 0) {
            newLevel = 0;
        }
        player.setLevel(newLevel);
        return true;
    }
}

