/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.icon.requirement;

import com.google.common.base.Preconditions;
import me.filoghost.chestcommands.config.Lang;
import me.filoghost.chestcommands.hook.VaultEconomyHook;
import me.filoghost.chestcommands.icon.requirement.Requirement;
import me.filoghost.chestcommands.logging.Errors;
import org.bukkit.entity.Player;

public class RequiredMoney
implements Requirement {
    private final double moneyAmount;

    public RequiredMoney(double moneyAmount) {
        Preconditions.checkArgument((moneyAmount > 0.0 ? 1 : 0) != 0, (Object)"money amount must be positive");
        this.moneyAmount = moneyAmount;
    }

    @Override
    public boolean hasCost(Player player) {
        if (!VaultEconomyHook.INSTANCE.isEnabled()) {
            player.sendMessage(Errors.User.configurationError("the item has a price, but Vault with a compatible economy plugin was not found. For security, the action has been blocked"));
            return false;
        }
        if (!VaultEconomyHook.hasMoney(player, this.moneyAmount)) {
            player.sendMessage(Lang.no_money.replace("{money}", VaultEconomyHook.formatMoney(this.moneyAmount)));
            return false;
        }
        return true;
    }

    @Override
    public boolean takeCost(Player player) {
        boolean success = VaultEconomyHook.takeMoney(player, this.moneyAmount);
        if (!success) {
            player.sendMessage(Errors.User.configurationError("a money transaction couldn't be executed"));
        }
        return success;
    }
}

