/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.icon.requirement.item;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import me.filoghost.chestcommands.fcommons.MaterialsHelper;
import me.filoghost.chestcommands.fcommons.Preconditions;
import me.filoghost.chestcommands.icon.requirement.item.RemainingItem;
import me.filoghost.chestcommands.icon.requirement.item.RequiredItem;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class InventoryTakeHelper {
    private final PlayerInventory inventory;
    private final List<RemainingItem> remainingItems;
    private boolean success;

    public InventoryTakeHelper(PlayerInventory inventory) {
        this.inventory = inventory;
        this.remainingItems = new ArrayList<RemainingItem>();
        for (int slotIndex = 0; slotIndex < inventory.getSize(); ++slotIndex) {
            ItemStack item = inventory.getItem(slotIndex);
            if (item == null || MaterialsHelper.isAir(item.getType())) continue;
            this.remainingItems.add(new RemainingItem(slotIndex, item));
        }
    }

    public boolean prepareTakeItems(List<RequiredItem> requiredItems) {
        ArrayList<RequiredItem> missingItems = new ArrayList<RequiredItem>();
        List sortedRequiredItems = requiredItems.stream().sorted(Comparator.comparing(RequiredItem::hasRestrictiveDurability).reversed()).collect(Collectors.toList());
        for (RequiredItem requiredItem : sortedRequiredItems) {
            int remainingRequiredAmount = requiredItem.getAmount();
            for (RemainingItem remainingItem : this.remainingItems) {
                int takenAmount;
                if (remainingItem.getAmount() > 0 && requiredItem.isMatchingType(remainingItem) && (remainingRequiredAmount -= (takenAmount = remainingItem.subtract(remainingRequiredAmount))) == 0) break;
            }
            if (remainingRequiredAmount <= 0) continue;
            missingItems.add(requiredItem);
        }
        this.success = missingItems.isEmpty();
        return this.success;
    }

    public void applyTakeItems() {
        Preconditions.checkState(this.success, "items take preparation was not run or successful");
        for (RemainingItem remainingItem : this.remainingItems) {
            int slotIndex = remainingItem.getSlotIndex();
            ItemStack inventoryItem = this.inventory.getItem(slotIndex);
            if (remainingItem.getAmount() == inventoryItem.getAmount()) continue;
            if (remainingItem.getAmount() > 0) {
                inventoryItem.setAmount(remainingItem.getAmount());
                continue;
            }
            this.inventory.setItem(slotIndex, null);
        }
    }
}

