/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.icon.requirement.item;

import me.filoghost.chestcommands.fcommons.Preconditions;
import me.filoghost.chestcommands.icon.requirement.item.RemainingItem;
import org.bukkit.Material;

public class RequiredItem {
    private final Material material;
    private final int amount;
    private short durability;
    private boolean isDurabilityRestrictive = false;

    public RequiredItem(Material material, int amount) {
        Preconditions.checkArgumentNotAir(material, "material");
        this.material = material;
        this.amount = amount;
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getAmount() {
        return this.amount;
    }

    public short getDurability() {
        return this.durability;
    }

    public void setRestrictiveDurability(short durability) {
        Preconditions.checkArgument(durability >= 0, "durability must be 0 or greater");
        this.durability = durability;
        this.isDurabilityRestrictive = true;
    }

    public boolean hasRestrictiveDurability() {
        return this.isDurabilityRestrictive;
    }

    public boolean isMatchingType(RemainingItem item) {
        return item != null && item.getMaterial() == this.material && this.isMatchingDurability(item.getDurability());
    }

    private boolean isMatchingDurability(short durability) {
        if (this.isDurabilityRestrictive) {
            return this.durability == durability;
        }
        return true;
    }
}

