/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.icon.requirement.item;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.filoghost.chestcommands.config.Lang;
import me.filoghost.chestcommands.icon.requirement.Requirement;
import me.filoghost.chestcommands.icon.requirement.item.InventoryTakeHelper;
import me.filoghost.chestcommands.icon.requirement.item.RequiredItem;
import me.filoghost.chestcommands.util.Utils;
import org.bukkit.entity.Player;

public class RequiredItems
implements Requirement {
    private final List<RequiredItem> items;

    public RequiredItems(List<RequiredItem> items) {
        this.items = ImmutableList.copyOf(items);
    }

    @Override
    public boolean hasCost(Player player) {
        InventoryTakeHelper inventoryTakeHelper = new InventoryTakeHelper(player.getInventory());
        boolean hasItems = inventoryTakeHelper.prepareTakeItems(this.items);
        if (!hasItems) {
            for (RequiredItem item : this.items) {
                player.sendMessage(Lang.no_required_item.replace("{material}", Utils.formatEnum(item.getMaterial())).replace("{amount}", Integer.toString(item.getAmount())).replace("{durability}", item.hasRestrictiveDurability() ? Short.toString(item.getDurability()) : Lang.any));
            }
        }
        return hasItems;
    }

    @Override
    public boolean takeCost(Player player) {
        InventoryTakeHelper inventoryTakeHelper = new InventoryTakeHelper(player.getInventory());
        boolean hasItems = inventoryTakeHelper.prepareTakeItems(this.items);
        if (!hasItems) {
            return false;
        }
        inventoryTakeHelper.applyTakeItems();
        return true;
    }
}

