/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.inventory;

import me.filoghost.chestcommands.api.Icon;
import me.filoghost.chestcommands.api.MenuView;
import me.filoghost.chestcommands.icon.RefreshableIcon;
import me.filoghost.chestcommands.inventory.InventoryGrid;
import me.filoghost.chestcommands.inventory.MenuInventoryHolder;
import me.filoghost.chestcommands.menu.BaseMenu;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultMenuView
implements MenuView {
    private final BaseMenu menu;
    private final Player viewer;
    private final InventoryGrid bukkitInventory;

    public DefaultMenuView(@NotNull BaseMenu menu, @NotNull Player viewer) {
        this.menu = menu;
        this.viewer = viewer;
        this.bukkitInventory = new InventoryGrid(new MenuInventoryHolder(this), menu.getRows(), menu.getTitle());
        this.refresh();
    }

    @Override
    public void refresh() {
        for (int i = 0; i < this.menu.getIcons().getSize(); ++i) {
            Icon icon = this.menu.getIcons().getByIndex(i);
            if (icon == null) {
                this.bukkitInventory.setByIndex(i, null);
                continue;
            }
            if (icon instanceof RefreshableIcon) {
                ItemStack newItemStack = ((RefreshableIcon)((Object)icon)).updateRendering(this.viewer, (ItemStack)this.bukkitInventory.getByIndex(i));
                this.bukkitInventory.setByIndex(i, newItemStack);
                continue;
            }
            this.bukkitInventory.setByIndex(i, icon.render(this.viewer));
        }
    }

    @Override
    public void close() {
        if (this.viewer.isOnline()) {
            this.viewer.closeInventory();
        }
    }

    public void open() {
        this.viewer.openInventory(this.bukkitInventory.getInventory());
    }

    @Nullable
    public Icon getIcon(int slot) {
        if (slot < 0 || slot >= this.bukkitInventory.getSize()) {
            return null;
        }
        return this.menu.getIcons().getByIndex(slot);
    }

    @Override
    @NotNull
    public BaseMenu getMenu() {
        return this.menu;
    }

    @Override
    @NotNull
    public Player getViewer() {
        return this.viewer;
    }
}

