/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.inventory;

import me.filoghost.chestcommands.fcommons.Preconditions;
import org.jetbrains.annotations.Nullable;

public abstract class Grid<T> {
    private final int rows;
    private final int columns;
    private final int size;

    public Grid(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.size = rows * columns;
    }

    public final void set(int row, int column, @Nullable T element) {
        this.setByIndex(this.toOrdinalIndex(row, column), element);
    }

    @Nullable
    public final T get(int row, int column) {
        return this.getByIndex(this.toOrdinalIndex(row, column));
    }

    @Nullable
    public final T getByIndex(int ordinalIndex) {
        Preconditions.checkIndex(ordinalIndex, this.getSize(), "ordinalIndex");
        return this.getByIndex0(ordinalIndex);
    }

    @Nullable
    protected abstract T getByIndex0(int var1);

    public final void setByIndex(int ordinalIndex, @Nullable T element) {
        Preconditions.checkIndex(ordinalIndex, this.getSize(), "ordinalIndex");
        this.setByIndex0(ordinalIndex, element);
    }

    protected abstract void setByIndex0(int var1, @Nullable T var2);

    private int toOrdinalIndex(int row, int column) {
        Preconditions.checkIndex(row, this.getRows(), "row");
        Preconditions.checkIndex(column, this.getColumns(), "column");
        int ordinalIndex = row * this.getColumns() + column;
        Preconditions.checkIndex(ordinalIndex, this.getSize(), "ordinalIndex");
        return ordinalIndex;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getSize() {
        return this.size;
    }
}

