/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.legacy;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import me.filoghost.chestcommands.fcommons.Preconditions;

public class Backup {
    private final Path dataFolder;
    private final Path backupFolder;
    private final Path infoFile;

    public Backup(Path dataFolder, String backupName) {
        this.dataFolder = dataFolder;
        Path backupsFolder = dataFolder.resolve("old_files");
        this.backupFolder = backupsFolder.resolve(backupName);
        this.infoFile = backupsFolder.resolve("readme.txt");
    }

    public static Backup newTimestampedBackup(Path dataFolder) {
        String date = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy.MM.dd-HH.mm"));
        String backupName = "backup_" + date;
        return new Backup(dataFolder, backupName);
    }

    public void addFile(Path fileToBackup) throws IOException {
        Preconditions.checkArgument(fileToBackup.startsWith(this.dataFolder), "file is not inside data folder");
        Path destination = this.backupFolder.resolve(this.dataFolder.relativize(fileToBackup));
        Files.createDirectories(destination.getParent(), new FileAttribute[0]);
        if (!Files.isRegularFile(destination, new LinkOption[0])) {
            Files.copy(fileToBackup, destination, new CopyOption[0]);
        }
        if (!Files.isRegularFile(this.infoFile, new LinkOption[0])) {
            Files.write(this.infoFile, Arrays.asList("Files in this folders are copies of original configuration files that have been automatically upgraded.", "", "Note: some configuration upgrades remove comments and other formatting (such as empty lines)."), new OpenOption[0]);
        }
    }
}

