/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.legacy;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import me.filoghost.chestcommands.config.ConfigManager;
import me.filoghost.chestcommands.fcommons.collection.CollectionUtils;
import me.filoghost.chestcommands.fcommons.config.ConfigLoader;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigException;
import me.filoghost.chestcommands.fcommons.logging.Log;
import me.filoghost.chestcommands.legacy.upgrade.Upgrade;
import me.filoghost.chestcommands.legacy.upgrade.UpgradeTask;
import me.filoghost.chestcommands.legacy.upgrade.UpgradeTaskException;
import me.filoghost.chestcommands.legacy.v4_0.V4_0_LangUpgradeTask;
import me.filoghost.chestcommands.legacy.v4_0.V4_0_MenuNodeRenameUpgradeTask;
import me.filoghost.chestcommands.legacy.v4_0.V4_0_MenuReformatUpgradeTask;
import me.filoghost.chestcommands.legacy.v4_0.V4_0_PlaceholdersUpgradeTask;
import me.filoghost.chestcommands.legacy.v4_0.V4_0_SettingsUpgradeTask;
import org.jetbrains.annotations.Nullable;

public class UpgradeList {
    private static final ImmutableList<Upgrade> orderedUpgrades = ImmutableList.of((Object)UpgradeList.multiTaskUpgrade("v4.0-menus-rename", configManager -> UpgradeList.createMenuTasks(configManager, V4_0_MenuNodeRenameUpgradeTask::new)), (Object)UpgradeList.multiTaskUpgrade("v4.0-menus-reformat", configManager -> {
        String legacyCommandSeparator = UpgradeList.readLegacyCommandSeparator(configManager);
        return UpgradeList.createMenuTasks(configManager, file -> new V4_0_MenuReformatUpgradeTask(configManager, (Path)file, legacyCommandSeparator));
    }), (Object)UpgradeList.singleTaskUpgrade("v4.0-config", V4_0_SettingsUpgradeTask::new), (Object)UpgradeList.singleTaskUpgrade("v4.0-placeholders", V4_0_PlaceholdersUpgradeTask::new), (Object)UpgradeList.singleTaskUpgrade("v4.0-lang", V4_0_LangUpgradeTask::new));

    private static Upgrade singleTaskUpgrade(String id, Upgrade.SingleTaskSupplier upgradeTaskSupplier) {
        return new Upgrade(id, configManager -> Collections.singletonList(upgradeTaskSupplier.getTask(configManager)));
    }

    private static Upgrade multiTaskUpgrade(String id, Upgrade.MultiTaskSupplier upgradeTasksSupplier) {
        return new Upgrade(id, upgradeTasksSupplier);
    }

    private static List<UpgradeTask> createMenuTasks(ConfigManager configManager, Function<Path, UpgradeTask> menuTaskSupplier) throws UpgradeTaskException {
        List<Path> menuFiles = UpgradeList.getMenuFiles(configManager);
        return CollectionUtils.transform(menuFiles, menuTaskSupplier);
    }

    private static List<Path> getMenuFiles(ConfigManager configManager) throws UpgradeTaskException {
        try {
            return configManager.getMenuFiles();
        }
        catch (IOException e) {
            throw new UpgradeTaskException("couldn't obtain a list of menu files", e);
        }
    }

    @Nullable
    private static String readLegacyCommandSeparator(ConfigManager configManager) {
        ConfigLoader settingsConfigLoader = configManager.getConfigLoader("config.yml");
        if (!settingsConfigLoader.fileExists()) {
            return null;
        }
        try {
            return settingsConfigLoader.load().getString("multiple-commands-separator");
        }
        catch (ConfigException e) {
            Log.warning("Failed to load \"" + settingsConfigLoader.getFile() + "\", assuming default command separator \";\".");
            return null;
        }
    }

    public static ImmutableList<Upgrade> getOrderedUpgrades() {
        return orderedUpgrades;
    }
}

