/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.legacy;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import me.filoghost.chestcommands.legacy.UpgradeList;
import me.filoghost.chestcommands.legacy.upgrade.Upgrade;

public class UpgradesDoneRegistry {
    private final Path saveFile;
    private final Set<String> upgradesDone;
    private boolean needSave;

    public UpgradesDoneRegistry(Path saveFile) throws IOException {
        this.saveFile = saveFile;
        this.upgradesDone = new HashSet<String>();
        if (Files.isRegularFile(saveFile, new LinkOption[0])) {
            try (Stream<String> lines = Files.lines(saveFile);){
                lines.filter(s -> !s.startsWith("#")).forEach(this.upgradesDone::add);
            }
        }
    }

    public void setAllDone() {
        for (Upgrade upgrade : UpgradeList.getOrderedUpgrades()) {
            this.setDone(upgrade);
        }
    }

    public void setDone(Upgrade upgrade) {
        if (this.upgradesDone.add(upgrade.getID())) {
            this.needSave = true;
        }
    }

    public boolean isDone(Upgrade upgrade) {
        return this.upgradesDone.contains(upgrade.getID());
    }

    public void save() throws IOException {
        if (this.needSave) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("#");
            lines.add("# WARNING: manually editing this file is not recommended");
            lines.add("#");
            lines.addAll(this.upgradesDone);
            Files.createDirectories(this.saveFile.getParent(), new FileAttribute[0]);
            Files.write(this.saveFile, lines, new OpenOption[0]);
            this.needSave = false;
        }
    }
}

