/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.legacy;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import me.filoghost.chestcommands.config.ConfigManager;
import me.filoghost.chestcommands.fcommons.logging.ErrorCollector;
import me.filoghost.chestcommands.fcommons.logging.Log;
import me.filoghost.chestcommands.legacy.Backup;
import me.filoghost.chestcommands.legacy.UpgradeExecutorException;
import me.filoghost.chestcommands.legacy.UpgradeList;
import me.filoghost.chestcommands.legacy.UpgradesDoneRegistry;
import me.filoghost.chestcommands.legacy.upgrade.Upgrade;
import me.filoghost.chestcommands.legacy.upgrade.UpgradeTask;
import me.filoghost.chestcommands.legacy.upgrade.UpgradeTaskException;
import me.filoghost.chestcommands.logging.Errors;

public class UpgradesExecutor {
    private final ConfigManager configManager;
    private boolean allUpgradesSuccessful;
    private UpgradesDoneRegistry upgradesDoneRegistry;

    public UpgradesExecutor(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public boolean run(boolean isFreshInstall, ErrorCollector errorCollector) throws UpgradeExecutorException {
        this.allUpgradesSuccessful = true;
        Path upgradesDoneFile = this.configManager.getRootDataFolder().resolve(".upgrades-done");
        try {
            this.upgradesDoneRegistry = new UpgradesDoneRegistry(upgradesDoneFile);
        }
        catch (IOException e) {
            throw new UpgradeExecutorException(Errors.Upgrade.metadataReadError(upgradesDoneFile), e);
        }
        if (isFreshInstall) {
            this.upgradesDoneRegistry.setAllDone();
        } else {
            Backup backup = Backup.newTimestampedBackup(this.configManager.getRootDataFolder());
            this.runMissingUpgrades(backup, errorCollector);
        }
        try {
            this.upgradesDoneRegistry.save();
        }
        catch (IOException e) {
            throw new UpgradeExecutorException(Errors.Upgrade.metadataSaveError(upgradesDoneFile), e);
        }
        return this.allUpgradesSuccessful;
    }

    private void runMissingUpgrades(Backup backup, ErrorCollector errorCollector) {
        for (Upgrade upgrade : UpgradeList.getOrderedUpgrades()) {
            if (this.upgradesDoneRegistry.isDone(upgrade)) continue;
            boolean allTasksSuccessful = this.tryRunUpgradeTasks(upgrade, backup, errorCollector);
            if (allTasksSuccessful) {
                this.upgradesDoneRegistry.setDone(upgrade);
                continue;
            }
            this.allUpgradesSuccessful = false;
        }
    }

    private boolean tryRunUpgradeTasks(Upgrade upgrade, Backup backup, ErrorCollector errorCollector) {
        List<UpgradeTask> upgradeTasks;
        boolean allTasksSuccessful = true;
        try {
            upgradeTasks = upgrade.createUpgradeTasks(this.configManager);
        }
        catch (UpgradeTaskException e) {
            errorCollector.add(e, "error while trying to prepare an automatic configuration upgrade");
            return false;
        }
        for (UpgradeTask upgradeTask : upgradeTasks) {
            try {
                boolean modified = upgradeTask.runAndBackupIfNecessary(backup);
                if (!modified) continue;
                Log.info("Automatically upgraded configuration file \"" + upgradeTask.getUpgradedFile() + "\". A backup of the old file has been saved.");
            }
            catch (UpgradeTaskException e) {
                allTasksSuccessful = false;
                errorCollector.add(e, Errors.Upgrade.failedSingleUpgrade(upgradeTask.getOriginalFile()));
            }
        }
        return allTasksSuccessful;
    }
}

