/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.legacy.upgrade;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigLoadException;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigSaveException;
import me.filoghost.chestcommands.legacy.upgrade.RegexReplacer;
import me.filoghost.chestcommands.legacy.upgrade.UpgradeTask;

public abstract class RegexUpgradeTask
extends UpgradeTask {
    private final Path file;
    private List<String> newContents;
    private Stream<String> linesStream;

    public RegexUpgradeTask(Path file) {
        this.file = file;
    }

    @Override
    public final Path getOriginalFile() {
        return this.file;
    }

    @Override
    public final Path getUpgradedFile() {
        return this.file;
    }

    @Override
    public final void computeChanges() throws ConfigLoadException {
        List<String> lines;
        if (!Files.isRegularFile(this.file, new LinkOption[0])) {
            return;
        }
        try {
            lines = Files.readAllLines(this.file);
        }
        catch (IOException e) {
            throw new ConfigLoadException("I/O exception while reading file", e);
        }
        this.linesStream = lines.stream();
        this.computeRegexChanges();
        this.newContents = this.linesStream.collect(Collectors.toList());
        if (!this.newContents.equals(lines)) {
            this.setSaveRequired();
        }
    }

    @Override
    public final void saveChanges() throws ConfigSaveException {
        try {
            Files.write(this.file, this.newContents, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ConfigSaveException("I/O exception while writing data to file", e);
        }
    }

    protected abstract void computeRegexChanges();

    protected void replaceString(String target, String replacement) {
        this.replaceRegex(Pattern.compile(Pattern.quote(target)), matcher -> replacement);
    }

    protected void replaceSubNode(String oldNode, String newNode) {
        this.replaceRegex(Pattern.compile("(^\\s+)" + Pattern.quote(oldNode) + "(:)"), matcher -> matcher.group(1) + newNode + matcher.group(2));
    }

    protected void replaceRegex(Pattern regex, Function<Matcher, String> replaceCallback) {
        this.linesStream = this.linesStream.map(new RegexReplacer(regex, replaceCallback));
    }
}

