/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.legacy.upgrade;

import java.io.IOException;
import java.nio.file.Path;
import me.filoghost.chestcommands.fcommons.Preconditions;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigLoadException;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigSaveException;
import me.filoghost.chestcommands.legacy.Backup;
import me.filoghost.chestcommands.legacy.upgrade.UpgradeTaskException;
import me.filoghost.chestcommands.logging.Errors;

public abstract class UpgradeTask {
    private boolean saveRequired;
    private boolean hasRun;

    protected void setSaveRequired() {
        this.saveRequired = true;
    }

    public boolean runAndBackupIfNecessary(Backup backup) throws UpgradeTaskException {
        Preconditions.checkState(!this.hasRun, "Upgrade task has already run");
        this.hasRun = true;
        try {
            this.computeChanges();
        }
        catch (ConfigLoadException e) {
            throw new UpgradeTaskException(Errors.Upgrade.loadError(this.getOriginalFile()), e);
        }
        if (this.saveRequired) {
            try {
                backup.addFile(this.getOriginalFile());
            }
            catch (IOException e) {
                throw new UpgradeTaskException(Errors.Upgrade.backupError(this.getOriginalFile()), e);
            }
            try {
                this.saveChanges();
            }
            catch (ConfigSaveException e) {
                throw new UpgradeTaskException(Errors.Upgrade.saveError(this.getUpgradedFile()), e);
            }
            return true;
        }
        return false;
    }

    public abstract Path getOriginalFile();

    public abstract Path getUpgradedFile();

    protected abstract void computeChanges() throws ConfigLoadException;

    protected abstract void saveChanges() throws ConfigSaveException;
}

