/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.legacy.upgrade;

import java.nio.file.Path;
import me.filoghost.chestcommands.fcommons.config.Config;
import me.filoghost.chestcommands.fcommons.config.ConfigLoader;
import me.filoghost.chestcommands.fcommons.config.FileConfig;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigLoadException;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigSaveException;
import me.filoghost.chestcommands.legacy.upgrade.UpgradeTask;

public abstract class YamlUpgradeTask
extends UpgradeTask {
    private final ConfigLoader configLoader;
    private Config updatedConfig;

    public YamlUpgradeTask(ConfigLoader configLoader) {
        this.configLoader = configLoader;
    }

    @Override
    public final Path getOriginalFile() {
        return this.configLoader.getFile();
    }

    @Override
    public final Path getUpgradedFile() {
        return this.configLoader.getFile();
    }

    @Override
    public final void computeChanges() throws ConfigLoadException {
        if (!this.configLoader.fileExists()) {
            return;
        }
        FileConfig config = this.configLoader.load();
        this.computeYamlChanges(config);
        this.updatedConfig = config;
    }

    @Override
    public final void saveChanges() throws ConfigSaveException {
        this.configLoader.save(this.updatedConfig);
    }

    protected abstract void computeYamlChanges(Config var1);

    protected void removeNode(Config config, String node) {
        if (config.contains(node)) {
            config.remove(node);
            this.setSaveRequired();
        }
    }

    protected void replaceStringValue(Config settingsConfig, String node, String target, String replacement) {
        String value = settingsConfig.getString(node);
        if (value.contains(target)) {
            settingsConfig.setString(node, value.replace(target, replacement));
            this.setSaveRequired();
        }
    }
}

