/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.legacy.v4_0;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import me.filoghost.chestcommands.config.ConfigManager;
import me.filoghost.chestcommands.fcommons.Strings;
import me.filoghost.chestcommands.fcommons.config.Config;
import me.filoghost.chestcommands.fcommons.config.ConfigSection;
import me.filoghost.chestcommands.fcommons.config.ConfigValueType;
import me.filoghost.chestcommands.legacy.upgrade.YamlUpgradeTask;
import me.filoghost.chestcommands.parsing.icon.AttributeType;

public class V4_0_MenuReformatUpgradeTask
extends YamlUpgradeTask {
    private final String legacyCommandSeparator;

    public V4_0_MenuReformatUpgradeTask(ConfigManager configManager, Path menuFile, String legacyCommandSeparator) {
        super(configManager.getConfigLoader(menuFile));
        this.legacyCommandSeparator = legacyCommandSeparator;
    }

    @Override
    public void computeYamlChanges(Config menuConfig) {
        menuConfig.setHeader(new String[0]);
        for (String key : menuConfig.getKeys()) {
            ConfigSection section = menuConfig.getConfigSection(key);
            if (section == null) continue;
            if (key.equals("menu-settings")) {
                this.upgradeMenuSettings(section);
                continue;
            }
            this.upgradeIcon(section);
        }
    }

    private void upgradeMenuSettings(ConfigSection section) {
        this.expandInlineList(section, "commands", ";");
        this.expandInlineList(section, "open-actions", this.legacyCommandSeparator);
        this.updateActionPrefixes(section, "open-actions");
    }

    private void upgradeIcon(ConfigSection section) {
        this.expandInlineList(section, AttributeType.ENCHANTMENTS.getAttributeName(), ";");
        this.expandInlineList(section, AttributeType.ACTIONS.getAttributeName(), this.legacyCommandSeparator);
        this.updateActionPrefixes(section, AttributeType.ACTIONS.getAttributeName());
        this.expandSingletonList(section, AttributeType.REQUIRED_ITEMS.getAttributeName());
        this.expandInlineItemstack(section);
    }

    private void updateActionPrefixes(ConfigSection config, String node) {
        List<String> actions = config.getStringList(node);
        if (actions == null) {
            return;
        }
        for (int i = 0; i < actions.size(); ++i) {
            String oldAction;
            String newAction = oldAction = actions.get(i);
            newAction = this.replacePrefix(newAction, "menu:", "open:");
            newAction = this.replacePrefix(newAction, "givemoney:", "give-money:");
            newAction = this.replacePrefix(newAction, "dragonbar:", "dragon-bar:");
            if ((newAction = this.replacePrefix(newAction, "server ", "server: ")).equals(oldAction)) continue;
            this.setSaveRequired();
            actions.set(i, newAction);
        }
        config.setStringList(node, actions);
    }

    private String replacePrefix(String action, String oldPrefix, String newPrefix) {
        if (action.startsWith(oldPrefix)) {
            this.setSaveRequired();
            return newPrefix + action.substring(oldPrefix.length());
        }
        return action;
    }

    private void expandInlineItemstack(ConfigSection section) {
        String[] parts;
        String material = section.getString(AttributeType.MATERIAL.getAttributeName());
        if (material == null) {
            return;
        }
        if (material.contains(",")) {
            parts = Strings.trimmedSplit(material, ",", 2);
            if (!section.contains(AttributeType.AMOUNT.getAttributeName())) {
                try {
                    section.setInt(AttributeType.AMOUNT.getAttributeName(), Integer.parseInt(parts[1]));
                }
                catch (NumberFormatException e) {
                    section.setString(AttributeType.AMOUNT.getAttributeName(), parts[1]);
                }
            }
            material = parts[0];
            section.setString(AttributeType.MATERIAL.getAttributeName(), material);
            this.setSaveRequired();
        }
        if (material.contains(":")) {
            parts = Strings.trimmedSplit(material, ":", 2);
            if (!section.contains(AttributeType.DURABILITY.getAttributeName())) {
                try {
                    section.setInt(AttributeType.DURABILITY.getAttributeName(), Integer.parseInt(parts[1]));
                }
                catch (NumberFormatException e) {
                    section.setString(AttributeType.DURABILITY.getAttributeName(), parts[1]);
                }
            }
            material = parts[0];
            section.setString(AttributeType.MATERIAL.getAttributeName(), material);
            this.setSaveRequired();
        }
    }

    private void expandInlineList(ConfigSection config, String node, String separator) {
        if (config.get(node).isPresentAs(ConfigValueType.STRING)) {
            config.setStringList(node, this.splitListElements(config.getString(node), separator));
            this.setSaveRequired();
        }
    }

    private void expandSingletonList(ConfigSection config, String node) {
        if (config.get(node).isPresentAs(ConfigValueType.STRING)) {
            config.setStringList(node, Collections.singletonList(config.getString(node)));
            this.setSaveRequired();
        }
    }

    private List<String> splitListElements(String input, String separator) {
        if (separator == null || separator.length() == 0) {
            separator = ";";
        }
        String[] splitValues = Strings.trimmedSplit(input, Pattern.quote(separator));
        ArrayList<String> values = new ArrayList<String>();
        for (String value : splitValues) {
            if (value.isEmpty()) continue;
            values.add(value);
        }
        if (values.isEmpty()) {
            values.add("");
        }
        return values;
    }
}

