/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.legacy.v4_0;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import me.filoghost.chestcommands.config.ConfigManager;
import me.filoghost.chestcommands.fcommons.Strings;
import me.filoghost.chestcommands.fcommons.config.Config;
import me.filoghost.chestcommands.fcommons.config.ConfigLoader;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigLoadException;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigSaveException;
import me.filoghost.chestcommands.legacy.upgrade.UpgradeTask;
import org.apache.commons.lang.StringEscapeUtils;

public class V4_0_PlaceholdersUpgradeTask
extends UpgradeTask {
    private final Path oldPlaceholdersFile;
    private final ConfigLoader newPlaceholdersConfigLoader;
    private Config updatedConfig;

    public V4_0_PlaceholdersUpgradeTask(ConfigManager configManager) {
        this.oldPlaceholdersFile = configManager.getRootDataFolder().resolve("placeholders.yml");
        this.newPlaceholdersConfigLoader = configManager.getConfigLoader("custom-placeholders.yml");
    }

    @Override
    public Path getOriginalFile() {
        return this.oldPlaceholdersFile;
    }

    @Override
    public Path getUpgradedFile() {
        return this.newPlaceholdersConfigLoader.getFile();
    }

    @Override
    public void computeChanges() throws ConfigLoadException {
        List<String> lines;
        if (!Files.isRegularFile(this.oldPlaceholdersFile, new LinkOption[0])) {
            return;
        }
        Config newPlaceholdersConfig = new Config();
        try {
            lines = Files.readAllLines(this.oldPlaceholdersFile);
        }
        catch (IOException e) {
            throw new ConfigLoadException("I/O exception while reading file", e);
        }
        for (String line : lines) {
            if (line.isEmpty() || line.startsWith("#") || !line.contains(":")) continue;
            String[] parts = Strings.trimmedSplit(line, ":", 2);
            String placeholder = V4_0_PlaceholdersUpgradeTask.unquote(parts[0]);
            String replacement = StringEscapeUtils.unescapeJava((String)V4_0_PlaceholdersUpgradeTask.unquote(parts[1]));
            newPlaceholdersConfig.setString("placeholders." + placeholder, replacement);
            this.setSaveRequired();
        }
        this.updatedConfig = newPlaceholdersConfig;
    }

    @Override
    public void saveChanges() throws ConfigSaveException {
        try {
            Files.deleteIfExists(this.oldPlaceholdersFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.newPlaceholdersConfigLoader.save(this.updatedConfig);
    }

    private static String unquote(String input) {
        if (input.length() < 2) {
            return input;
        }
        if (input.startsWith("'") && input.endsWith("'")) {
            return input.substring(1, input.length() - 1);
        }
        if (input.startsWith("\"") && input.endsWith("\"")) {
            return input.substring(1, input.length() - 1);
        }
        return input;
    }
}

