/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.listener;

import java.util.Map;
import java.util.WeakHashMap;
import me.filoghost.chestcommands.ChestCommands;
import me.filoghost.chestcommands.api.Icon;
import me.filoghost.chestcommands.api.Menu;
import me.filoghost.chestcommands.config.Settings;
import me.filoghost.chestcommands.fcommons.logging.Log;
import me.filoghost.chestcommands.inventory.DefaultMenuView;
import me.filoghost.chestcommands.logging.Errors;
import me.filoghost.chestcommands.menu.InternalMenu;
import me.filoghost.chestcommands.menu.MenuManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;

public class InventoryListener
implements Listener {
    private final Map<Player, Long> antiClickSpam = new WeakHashMap<Player, Long>();

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onInteract(PlayerInteractEvent event) {
        if (event.hasItem() && event.getAction() != Action.PHYSICAL) {
            MenuManager.openMenuByItem(event.getPlayer(), event.getItem(), event.getAction());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    public void onEarlyInventoryClick(InventoryClickEvent event) {
        if (MenuManager.isMenuInventory(event.getInventory())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onLateInventoryClick(InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        DefaultMenuView menuView = MenuManager.getOpenMenuView(inventory);
        if (menuView == null) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        Player clicker = (Player)event.getWhoClicked();
        Icon icon = menuView.getIcon(slot);
        if (icon == null) {
            return;
        }
        Long cooldownUntil = this.antiClickSpam.get(clicker);
        long now = System.currentTimeMillis();
        int minDelay = Settings.anti_click_spam_delay;
        if (minDelay > 0) {
            if (cooldownUntil != null && cooldownUntil > now) {
                return;
            }
            this.antiClickSpam.put(clicker, now + (long)minDelay);
        }
        Bukkit.getScheduler().runTask(ChestCommands.getInstance(), () -> {
            try {
                icon.onClick(menuView, clicker);
            }
            catch (Throwable t) {
                this.handleIconClickException(clicker, menuView.getMenu(), t);
                menuView.close();
            }
        });
    }

    private void handleIconClickException(Player clicker, Menu menu, Throwable throwable) {
        String menuDescription = menu.getPlugin() == ChestCommands.getInstance() ? "the menu \"" + Errors.formatPath(((InternalMenu)menu).getSourceFile()) + "\"" : "a menu created by the plugin \"" + menu.getPlugin().getName() + "\"";
        Log.severe("Encountered an exception while handling a click inside " + menuDescription, throwable);
        clicker.sendMessage(ChatColor.RED + "An internal error occurred when you clicked on the item.");
    }
}

