/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.listener;

import me.filoghost.chestcommands.config.Lang;
import me.filoghost.chestcommands.menu.InternalMenu;
import me.filoghost.chestcommands.menu.MenuManager;
import me.filoghost.chestcommands.util.Utils;
import org.bukkit.ChatColor;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class SignListener
implements Listener {
    private static final int HEADER_LINE = 0;
    private static final int FILENAME_LINE = 1;
    private static final String SIGN_CREATION_TRIGGER = "[menu]";
    private static final ChatColor VALID_SIGN_COLOR = ChatColor.DARK_BLUE;
    private static final String VALID_SIGN_HEADER = VALID_SIGN_COLOR + "[menu]";

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onSignClick(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        BlockState clickedBlockState = event.getClickedBlock().getState();
        if (!(clickedBlockState instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)clickedBlockState;
        if (!sign.getLine(0).equalsIgnoreCase(VALID_SIGN_HEADER)) {
            return;
        }
        String menuFileName = Utils.addYamlExtension(sign.getLine(1).trim());
        InternalMenu menu = MenuManager.getMenuByFileName(menuFileName);
        if (menu == null) {
            event.getPlayer().sendMessage(Lang.menu_not_found);
            return;
        }
        menu.openCheckingPermission(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCreateMenuSign(SignChangeEvent event) {
        Player player = event.getPlayer();
        if (this.isCreatingMenuSign(event.getLine(0)) && this.canCreateMenuSign(player)) {
            String menuFileName = event.getLine(1).trim();
            if (menuFileName.isEmpty()) {
                event.setCancelled(true);
                player.sendMessage(ChatColor.RED + "You must write a menu name in the second line.");
                return;
            }
            InternalMenu menu = MenuManager.getMenuByFileName(menuFileName = Utils.addYamlExtension(menuFileName));
            if (menu == null) {
                event.setCancelled(true);
                player.sendMessage(ChatColor.RED + "Menu \"" + menuFileName + "\" was not found.");
                return;
            }
            event.setLine(0, VALID_SIGN_COLOR + event.getLine(0));
            player.sendMessage(ChatColor.GREEN + "Successfully created a sign for the menu " + menuFileName + ".");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignChangeMonitor(SignChangeEvent event) {
        if (this.isValidMenuSign(event.getLine(0)) && !this.canCreateMenuSign(event.getPlayer())) {
            event.setLine(0, ChatColor.stripColor((String)event.getLine(0)));
        }
    }

    private boolean isCreatingMenuSign(String headerLine) {
        return headerLine.equalsIgnoreCase(SIGN_CREATION_TRIGGER);
    }

    private boolean isValidMenuSign(String headerLine) {
        return headerLine.equalsIgnoreCase(VALID_SIGN_HEADER);
    }

    private boolean canCreateMenuSign(Player player) {
        return player.hasPermission("chestcommands.sign");
    }
}

