/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.logging;

import java.util.List;
import me.filoghost.chestcommands.fcommons.Strings;

class MessagePartJoiner {
    private final StringBuilder output;
    private String previousMessagePart;
    private boolean appendedFirstSentenceSeparator;

    public static String join(List<String> messageParts) {
        int estimateLength = MessagePartJoiner.getEstimateLength(messageParts);
        MessagePartJoiner errorMessageBuilder = new MessagePartJoiner(estimateLength);
        for (String messagePart : messageParts) {
            errorMessageBuilder.append(messagePart);
        }
        return errorMessageBuilder.build();
    }

    private static int getEstimateLength(List<String> messageParts) {
        int estimateLength = 0;
        for (String messagePart : messageParts) {
            estimateLength += messagePart.length();
        }
        return estimateLength += (messageParts.size() - 1) * 2;
    }

    private MessagePartJoiner(int estimateLength) {
        this.output = new StringBuilder(estimateLength);
    }

    private void append(String messagePart) {
        this.appendSeparator();
        this.appendMessagePart(messagePart);
        this.previousMessagePart = messagePart;
    }

    private void appendMessagePart(String messagePart) {
        if (this.previousMessagePart == null || this.previousMessagePart.endsWith(".")) {
            this.output.append(Strings.capitalizeFirst(messagePart));
        } else {
            this.output.append(messagePart);
        }
    }

    private void appendSeparator() {
        if (this.previousMessagePart != null) {
            if (this.previousMessagePart.endsWith(".")) {
                this.output.append(" ");
                this.appendedFirstSentenceSeparator = false;
            } else if (!this.appendedFirstSentenceSeparator) {
                this.output.append(": ");
                this.appendedFirstSentenceSeparator = true;
            } else {
                this.output.append(", ");
            }
        }
    }

    private String build() {
        return this.output.toString();
    }
}

