/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.logging;

import java.util.ArrayList;
import java.util.Collection;
import me.filoghost.chestcommands.ChestCommands;
import me.filoghost.chestcommands.fcommons.CommonsUtil;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigException;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigSyntaxException;
import me.filoghost.chestcommands.fcommons.logging.ErrorCollector;
import me.filoghost.chestcommands.fcommons.logging.ErrorLog;
import me.filoghost.chestcommands.legacy.UpgradeExecutorException;
import me.filoghost.chestcommands.legacy.upgrade.UpgradeTaskException;
import me.filoghost.chestcommands.logging.ErrorPrintInfo;
import me.filoghost.chestcommands.logging.MessagePartJoiner;
import me.filoghost.chestcommands.parsing.ParseException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;

public class PrintableErrorCollector
extends ErrorCollector {
    @Override
    public void logToConsole() {
        StringBuilder output = new StringBuilder();
        if (this.errors.size() > 0) {
            output.append(ChestCommands.CHAT_PREFIX).append(ChatColor.RED).append("Encountered ").append(this.errors.size()).append(" error(s) on load:\n");
            output.append(" \n");
            int index = 1;
            for (ErrorLog error : this.errors) {
                ErrorPrintInfo printFormat = this.getErrorPrintInfo(index, error);
                PrintableErrorCollector.printError(output, printFormat);
                ++index;
            }
        }
        Bukkit.getConsoleSender().sendMessage(output.toString());
    }

    private ErrorPrintInfo getErrorPrintInfo(int index, ErrorLog error) {
        ArrayList<String> message = new ArrayList<String>((Collection<String>)error.getMessage().asList());
        String details = null;
        Throwable cause = error.getCause();
        while (true) {
            if (cause instanceof ConfigSyntaxException) {
                message.add(cause.getMessage());
                details = ((ConfigSyntaxException)cause).getSyntaxErrorDetails();
                cause = null;
                continue;
            }
            if (!(cause instanceof ConfigException) && !(cause instanceof ParseException) && !(cause instanceof UpgradeTaskException) && !(cause instanceof UpgradeExecutorException)) break;
            message.add(cause.getMessage());
            cause = cause.getCause();
        }
        return new ErrorPrintInfo(index, message, details, cause);
    }

    private static void printError(StringBuilder output, ErrorPrintInfo error) {
        output.append(ChatColor.YELLOW).append(error.getIndex()).append(") ");
        output.append(ChatColor.WHITE).append(MessagePartJoiner.join(error.getMessage()));
        if (error.getDetails() != null) {
            output.append(". Details:\n");
            output.append(ChatColor.YELLOW).append(error.getDetails()).append("\n");
        } else {
            output.append(".\n");
        }
        if (error.getCause() != null) {
            output.append(ChatColor.DARK_GRAY);
            output.append("--------[ Exception details ]--------\n");
            output.append(CommonsUtil.getStackTraceString(error.getCause()));
            output.append("-------------------------------------\n");
        }
        output.append(" \n");
        output.append(ChatColor.RESET);
    }
}

