/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.menu;

import me.filoghost.chestcommands.api.Icon;
import me.filoghost.chestcommands.api.Menu;
import me.filoghost.chestcommands.api.MenuView;
import me.filoghost.chestcommands.fcommons.Preconditions;
import me.filoghost.chestcommands.inventory.ArrayGrid;
import me.filoghost.chestcommands.inventory.DefaultMenuView;
import me.filoghost.chestcommands.inventory.Grid;
import me.filoghost.chestcommands.menu.MenuManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMenu
implements Menu {
    private final String title;
    private final Grid<Icon> icons;

    public BaseMenu(@NotNull String title, int rows) {
        Preconditions.notNull(title, "title");
        Preconditions.checkArgument(rows > 0, "rows must be greater than 0");
        this.title = title;
        this.icons = new ArrayGrid<Icon>(rows, 9);
    }

    @Override
    public void setIcon(int row, int column, @Nullable Icon icon) {
        this.icons.set(row, column, icon);
    }

    @Override
    @Nullable
    public Icon getIcon(int row, int column) {
        return this.icons.get(row, column);
    }

    @Override
    @NotNull
    public MenuView open(@NotNull Player player) {
        Preconditions.notNull(player, "player");
        DefaultMenuView menuView = new DefaultMenuView(this, player);
        menuView.open();
        return menuView;
    }

    @Override
    public void refreshOpenViews() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            DefaultMenuView menuView = MenuManager.getOpenMenuView(player);
            if (menuView == null || menuView.getMenu() != this) continue;
            menuView.refresh();
        }
    }

    @Override
    public int getRows() {
        return this.icons.getRows();
    }

    @Override
    public int getColumns() {
        return this.icons.getColumns();
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @NotNull
    public Grid<Icon> getIcons() {
        return this.icons;
    }
}

