/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.menu;

import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.List;
import me.filoghost.chestcommands.ChestCommands;
import me.filoghost.chestcommands.action.Action;
import me.filoghost.chestcommands.api.MenuView;
import me.filoghost.chestcommands.config.Lang;
import me.filoghost.chestcommands.fcommons.collection.CollectionUtils;
import me.filoghost.chestcommands.menu.BaseMenu;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class InternalMenu
extends BaseMenu {
    private final Path sourceFile;
    private final String openPermission;
    private ImmutableList<Action> openActions;
    private int refreshTicks;

    public InternalMenu(@NotNull String title, int rows, @NotNull Path sourceFile) {
        super(title, rows);
        this.sourceFile = sourceFile;
        this.openPermission = "chestcommands.open." + sourceFile.getFileName();
    }

    @NotNull
    public Path getSourceFile() {
        return this.sourceFile;
    }

    public void setOpenActions(List<Action> openAction) {
        this.openActions = CollectionUtils.immutableCopy(openAction);
    }

    public String getOpenPermission() {
        return this.openPermission;
    }

    public int getRefreshTicks() {
        return this.refreshTicks;
    }

    public void setRefreshTicks(int refreshTicks) {
        this.refreshTicks = refreshTicks;
    }

    @Override
    @NotNull
    public MenuView open(@NotNull Player player) {
        if (this.openActions != null) {
            for (Action openAction : this.openActions) {
                openAction.execute(player);
            }
        }
        return super.open(player);
    }

    @Override
    public Plugin getPlugin() {
        return ChestCommands.getInstance();
    }

    public void openCheckingPermission(Player player) {
        if (player.hasPermission(this.openPermission)) {
            this.open(player);
        } else {
            this.sendNoOpenPermissionMessage((CommandSender)player);
        }
    }

    public void sendNoOpenPermissionMessage(CommandSender sender) {
        String noPermMessage = Lang.no_open_permission;
        if (noPermMessage != null && !noPermMessage.isEmpty()) {
            sender.sendMessage(noPermMessage.replace("{permission}", this.openPermission));
        }
    }
}

