/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.parsing;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.filoghost.chestcommands.action.Action;
import me.filoghost.chestcommands.action.BroadcastAction;
import me.filoghost.chestcommands.action.ChangeServerAction;
import me.filoghost.chestcommands.action.ConsoleCommandAction;
import me.filoghost.chestcommands.action.DragonBarAction;
import me.filoghost.chestcommands.action.GiveItemAction;
import me.filoghost.chestcommands.action.GiveMoneyAction;
import me.filoghost.chestcommands.action.OpCommandAction;
import me.filoghost.chestcommands.action.OpenMenuAction;
import me.filoghost.chestcommands.action.PlaySoundAction;
import me.filoghost.chestcommands.action.PlayerCommandAction;
import me.filoghost.chestcommands.action.SendMessageAction;
import me.filoghost.chestcommands.parsing.ParseException;

public class ActionParser {
    public static Action parse(String serializedAction) throws ParseException {
        for (ActionType actionType : ActionType.values()) {
            Matcher matcher = actionType.prefixPattern.matcher(serializedAction);
            if (!matcher.find()) continue;
            serializedAction = matcher.replaceFirst("").trim();
            return actionType.actionFactory.create(serializedAction);
        }
        return new PlayerCommandAction(serializedAction);
    }

    private static enum ActionType {
        CONSOLE_COMMAND("console", ConsoleCommandAction::new),
        OP_COMMAND("op", OpCommandAction::new),
        OPEN("open", OpenMenuAction::new),
        SERVER("server", ChangeServerAction::new),
        TELL("tell", SendMessageAction::new),
        BROADCAST("broadcast", BroadcastAction::new),
        GIVE_ITEM("give", GiveItemAction::new),
        GIVE_MONEY("give-money", GiveMoneyAction::new),
        SOUND("sound", PlaySoundAction::new),
        BOSS_BAR("dragon-bar", DragonBarAction::new);

        private final Pattern prefixPattern;
        private final ActionFactory actionFactory;

        private ActionType(String prefix, ActionFactory actionFactory) {
            this.prefixPattern = Pattern.compile("^" + Pattern.quote(prefix) + ":", 2);
            this.actionFactory = actionFactory;
        }

        @FunctionalInterface
        private static interface ActionFactory {
            public Action create(String var1) throws ParseException;
        }
    }
}

