/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.parsing;

import me.filoghost.chestcommands.fcommons.Strings;
import me.filoghost.chestcommands.fcommons.collection.Registry;
import me.filoghost.chestcommands.logging.Errors;
import me.filoghost.chestcommands.parsing.NumberParser;
import me.filoghost.chestcommands.parsing.ParseException;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;

public final class ItemMetaParser {
    private static final Registry<DyeColor> DYE_COLORS_REGISTRY = Registry.fromEnumValues(DyeColor.class);
    private static final Registry<PatternType> PATTERN_TYPES_REGISTRY = Registry.fromEnumValues(PatternType.class);

    private ItemMetaParser() {
    }

    public static Color parseRGBColor(String input) throws ParseException {
        String[] split = Strings.trimmedSplit(input, ",");
        if (split.length != 3) {
            throw new ParseException("value must match the format \"red, green, blue\"");
        }
        int red = ItemMetaParser.parseColor(split[0], "red");
        int green = ItemMetaParser.parseColor(split[1], "green");
        int blue = ItemMetaParser.parseColor(split[2], "blue");
        return Color.fromRGB((int)red, (int)green, (int)blue);
    }

    private static int parseColor(String valueString, String colorName) throws ParseException {
        int value;
        try {
            value = NumberParser.getInteger(valueString);
        }
        catch (ParseException e) {
            throw new ParseException(Errors.Parsing.invalidColorNumber(valueString, colorName), e);
        }
        if (value < 0 || value > 255) {
            throw new ParseException(Errors.Parsing.invalidColorRange(valueString, colorName));
        }
        return value;
    }

    public static DyeColor parseDyeColor(String input) throws ParseException {
        return DYE_COLORS_REGISTRY.find(input).orElseThrow(() -> new ParseException(Errors.Parsing.unknownDyeColor(input)));
    }

    public static Pattern parseBannerPattern(String input) throws ParseException {
        String[] split = Strings.trimmedSplit(input, ":");
        if (split.length != 2) {
            throw new ParseException("value must match the format \"pattern:color\"");
        }
        PatternType patternType = PATTERN_TYPES_REGISTRY.find(split[0]).orElseThrow(() -> new ParseException(Errors.Parsing.unknownPatternType(split[0])));
        DyeColor patternColor = ItemMetaParser.parseDyeColor(split[1]);
        return new Pattern(patternColor, patternType);
    }
}

