/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.parsing;

import me.filoghost.chestcommands.fcommons.MaterialsHelper;
import me.filoghost.chestcommands.fcommons.Preconditions;
import me.filoghost.chestcommands.fcommons.Strings;
import me.filoghost.chestcommands.logging.Errors;
import me.filoghost.chestcommands.parsing.MaterialParser;
import me.filoghost.chestcommands.parsing.NumberParser;
import me.filoghost.chestcommands.parsing.ParseException;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemStackParser {
    private final Material material;
    private int amount = 1;
    private short durability = 0;
    private boolean hasExplicitDurability = false;

    public ItemStackParser(String input, boolean parseAmount) throws ParseException {
        String[] splitByColons;
        String[] splitAmount;
        Preconditions.notNull(input, "input");
        if (parseAmount && (splitAmount = Strings.trimmedSplit(input, ",", 2)).length > 1) {
            try {
                this.amount = NumberParser.getStrictlyPositiveInteger(splitAmount[1]);
            }
            catch (ParseException e) {
                throw new ParseException(Errors.Parsing.invalidAmount(splitAmount[1]), e);
            }
            input = splitAmount[0];
        }
        if ((splitByColons = Strings.trimmedSplit(input, ":", 2)).length > 1) {
            try {
                this.durability = NumberParser.getPositiveShort(splitByColons[1]);
            }
            catch (ParseException e) {
                throw new ParseException(Errors.Parsing.invalidDurability(splitByColons[1]), e);
            }
            this.hasExplicitDurability = true;
            input = splitByColons[0];
        }
        this.material = MaterialParser.parseMaterial(input);
    }

    public void checkNotAir() throws ParseException {
        if (MaterialsHelper.isAir(this.material)) {
            throw new ParseException("material cannot be air");
        }
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getAmount() {
        return this.amount;
    }

    public short getDurability() {
        return this.durability;
    }

    public boolean hasExplicitDurability() {
        return this.hasExplicitDurability;
    }

    public ItemStack createStack() {
        return new ItemStack(this.material, this.amount, this.durability);
    }
}

