/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.parsing;

import me.filoghost.chestcommands.parsing.ParseException;

public class NumberParser {
    public static double getStrictlyPositiveDouble(String input) throws ParseException {
        double value = NumberParser.getDouble(input);
        NumberParser.check(value > 0.0, "value must be greater than zero");
        return value;
    }

    private static double getDouble(String input) throws ParseException {
        try {
            return Double.parseDouble(input);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("value is not a valid decimal");
        }
    }

    public static float getFloat(String input) throws ParseException {
        try {
            return Float.parseFloat(input);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("value is not a valid decimal");
        }
    }

    public static short getPositiveShort(String input) throws ParseException {
        short value = NumberParser.getShort(input);
        NumberParser.check(value >= 0, "value must be zero or greater");
        return value;
    }

    private static short getShort(String input) throws ParseException {
        try {
            return Short.parseShort(input);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("value is not a valid short integer");
        }
    }

    public static int getStrictlyPositiveInteger(String input) throws ParseException {
        int value = NumberParser.getInteger(input);
        NumberParser.check(value > 0, "value must be greater than zero");
        return value;
    }

    public static int getInteger(String input) throws ParseException {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("value is not a valid integer");
        }
    }

    private static void check(boolean expression, String errorMessage) throws ParseException {
        if (!expression) {
            throw new ParseException(errorMessage);
        }
    }
}

