/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.parsing.icon;

import java.nio.file.Path;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.filoghost.chestcommands.attribute.AttributeErrorHandler;
import me.filoghost.chestcommands.attribute.IconAttribute;
import me.filoghost.chestcommands.fcommons.config.ConfigSection;
import me.filoghost.chestcommands.fcommons.config.ConfigValue;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigValueException;
import me.filoghost.chestcommands.fcommons.logging.ErrorCollector;
import me.filoghost.chestcommands.icon.InternalConfigurableIcon;
import me.filoghost.chestcommands.logging.Errors;
import me.filoghost.chestcommands.parsing.ParseException;
import me.filoghost.chestcommands.parsing.icon.AttributeType;
import org.bukkit.Material;

public class IconSettings {
    private final Path menuFile;
    private final String iconName;
    private final Map<AttributeType, IconAttribute> validAttributes;
    private final Set<AttributeType> invalidAttributes;

    public IconSettings(Path menuFile, String iconName) {
        this.menuFile = menuFile;
        this.iconName = iconName;
        this.validAttributes = new EnumMap<AttributeType, IconAttribute>(AttributeType.class);
        this.invalidAttributes = new HashSet<AttributeType>();
    }

    public InternalConfigurableIcon createIcon() {
        InternalConfigurableIcon icon = new InternalConfigurableIcon(Material.BEDROCK);
        for (IconAttribute attribute : this.validAttributes.values()) {
            attribute.apply(icon);
        }
        return icon;
    }

    public IconAttribute getAttributeValue(AttributeType attributeType) {
        return this.validAttributes.get((Object)attributeType);
    }

    public boolean isMissingAttribute(AttributeType attributeType) {
        return !this.validAttributes.containsKey((Object)attributeType) && !this.invalidAttributes.contains((Object)attributeType);
    }

    public void loadFrom(ConfigSection config, ErrorCollector errorCollector) {
        for (String attributeName : config.getKeys()) {
            AttributeType attributeType = null;
            try {
                attributeType = AttributeType.fromAttributeName(attributeName);
                if (attributeType == null) {
                    throw new ParseException("unknown attribute");
                }
                AttributeErrorHandler errorHandler = (listElement, e) -> errorCollector.add(e, Errors.Menu.invalidAttributeListElement(this, attributeName, listElement));
                ConfigValue configValue = config.get(attributeName);
                IconAttribute iconAttribute = attributeType.getParser().parse(configValue, errorHandler);
                this.validAttributes.put(attributeType, iconAttribute);
            }
            catch (ConfigValueException | ParseException e2) {
                errorCollector.add(e2, Errors.Menu.invalidAttribute(this, attributeName));
                if (attributeType == null) continue;
                this.invalidAttributes.add(attributeType);
            }
        }
    }

    public Path getMenuFile() {
        return this.menuFile;
    }

    public String getIconName() {
        return this.iconName;
    }
}

