/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.parsing.menu;

import java.util.ArrayList;
import java.util.List;
import me.filoghost.chestcommands.action.Action;
import me.filoghost.chestcommands.action.DisabledAction;
import me.filoghost.chestcommands.attribute.PositionAttribute;
import me.filoghost.chestcommands.fcommons.Colors;
import me.filoghost.chestcommands.fcommons.config.ConfigSection;
import me.filoghost.chestcommands.fcommons.config.FileConfig;
import me.filoghost.chestcommands.fcommons.config.exception.ConfigValueException;
import me.filoghost.chestcommands.fcommons.config.exception.MissingConfigValueException;
import me.filoghost.chestcommands.fcommons.logging.ErrorCollector;
import me.filoghost.chestcommands.logging.Errors;
import me.filoghost.chestcommands.menu.InternalMenu;
import me.filoghost.chestcommands.parsing.ActionParser;
import me.filoghost.chestcommands.parsing.ItemStackParser;
import me.filoghost.chestcommands.parsing.ParseException;
import me.filoghost.chestcommands.parsing.icon.AttributeType;
import me.filoghost.chestcommands.parsing.icon.IconSettings;
import me.filoghost.chestcommands.parsing.menu.ClickType;
import me.filoghost.chestcommands.parsing.menu.LoadedMenu;
import me.filoghost.chestcommands.parsing.menu.MenuOpenItem;
import me.filoghost.chestcommands.parsing.menu.MenuSettings;
import org.bukkit.ChatColor;

public class MenuParser {
    public static LoadedMenu loadMenu(FileConfig menuConfig, ErrorCollector errorCollector) {
        MenuSettings menuSettings = MenuParser.loadMenuSettings(menuConfig, errorCollector);
        List<IconSettings> iconSettingsList = MenuParser.loadIconSettingsList(menuConfig, errorCollector);
        InternalMenu menu = new InternalMenu(menuSettings.getTitle(), menuSettings.getRows(), menuConfig.getSourceFile());
        for (IconSettings iconSettings : iconSettingsList) {
            MenuParser.tryAddIconToMenu(menu, iconSettings, errorCollector);
        }
        menu.setRefreshTicks(menuSettings.getRefreshTicks());
        menu.setOpenActions((List<Action>)menuSettings.getOpenActions());
        return new LoadedMenu(menu, menuConfig.getSourceFile(), (List<String>)menuSettings.getCommands(), menuSettings.getOpenItem());
    }

    private static void tryAddIconToMenu(InternalMenu menu, IconSettings iconSettings, ErrorCollector errorCollector) {
        if (iconSettings.isMissingAttribute(AttributeType.POSITION_X)) {
            errorCollector.add(Errors.Menu.missingAttribute(iconSettings, AttributeType.POSITION_X));
        }
        if (iconSettings.isMissingAttribute(AttributeType.POSITION_Y)) {
            errorCollector.add(Errors.Menu.missingAttribute(iconSettings, AttributeType.POSITION_Y));
        }
        if (iconSettings.isMissingAttribute(AttributeType.MATERIAL)) {
            errorCollector.add(Errors.Menu.missingAttribute(iconSettings, AttributeType.MATERIAL));
        }
        PositionAttribute positionX = (PositionAttribute)iconSettings.getAttributeValue(AttributeType.POSITION_X);
        PositionAttribute positionY = (PositionAttribute)iconSettings.getAttributeValue(AttributeType.POSITION_Y);
        if (positionX == null || positionY == null) {
            return;
        }
        int row = positionY.getPosition() - 1;
        int column = positionX.getPosition() - 1;
        boolean invalidPosition = false;
        if (row < 0 || row >= menu.getRows()) {
            errorCollector.add(Errors.Menu.invalidAttribute(iconSettings, AttributeType.POSITION_Y), "it must be between 1 and " + menu.getRows());
            invalidPosition = true;
        }
        if (column < 0 || column >= menu.getColumns()) {
            errorCollector.add(Errors.Menu.invalidAttribute(iconSettings, AttributeType.POSITION_X), "it must be between 1 and " + menu.getColumns());
            invalidPosition = true;
        }
        if (invalidPosition) {
            return;
        }
        if (menu.getIcon(row, column) != null) {
            errorCollector.add(Errors.Menu.iconOverridesAnother(iconSettings));
        }
        menu.setIcon(row, column, iconSettings.createIcon());
    }

    private static MenuSettings loadMenuSettings(FileConfig config, ErrorCollector errorCollector) {
        String openItemMaterial;
        int rows;
        String title;
        ConfigSection settingsSection = config.getConfigSection("menu-settings");
        if (settingsSection == null) {
            errorCollector.add(Errors.Menu.missingSettingsSection(config.getSourceFile()));
            settingsSection = new ConfigSection();
        }
        try {
            title = Colors.addColors(settingsSection.getRequiredString("name"));
            if (title.length() > 32) {
                title = title.substring(0, 32);
            }
        }
        catch (ConfigValueException e) {
            title = ChatColor.DARK_RED + "No name set";
            MenuParser.addMenuSettingError(errorCollector, config, "name", e);
        }
        try {
            rows = settingsSection.getRequiredInt("rows");
            if (rows <= 0) {
                rows = 1;
            }
        }
        catch (ConfigValueException e) {
            rows = 6;
            MenuParser.addMenuSettingError(errorCollector, config, "rows", e);
        }
        MenuSettings menuSettings = new MenuSettings(title, rows);
        List<String> openCommands = settingsSection.getStringList("commands");
        menuSettings.setCommands(openCommands);
        List<String> serializedOpenActions = settingsSection.getStringList("open-actions");
        if (serializedOpenActions != null) {
            ArrayList<Action> openActions = new ArrayList<Action>();
            for (String serializedAction : serializedOpenActions) {
                if (serializedAction == null || serializedAction.isEmpty()) continue;
                try {
                    openActions.add(ActionParser.parse(serializedAction));
                }
                catch (ParseException e) {
                    errorCollector.add(e, Errors.Menu.invalidSettingListElement(config.getSourceFile(), "open-actions", serializedAction));
                    openActions.add(new DisabledAction(Errors.User.configurationError("an action linked to opening this menu was not executed because it was not valid")));
                }
            }
            menuSettings.setOpenActions(openActions);
        }
        if ((openItemMaterial = settingsSection.getString("open-with-item.material")) != null) {
            boolean leftClick = settingsSection.getBoolean("open-with-item.left-click");
            boolean rightClick = settingsSection.getBoolean("open-with-item.right-click");
            if (leftClick || rightClick) {
                try {
                    ItemStackParser itemReader = new ItemStackParser(openItemMaterial, false);
                    itemReader.checkNotAir();
                    ClickType clickType = ClickType.fromOptions(leftClick, rightClick);
                    MenuOpenItem openItem = new MenuOpenItem(itemReader.getMaterial(), clickType);
                    if (itemReader.hasExplicitDurability()) {
                        openItem.setRestrictiveDurability(itemReader.getDurability());
                    }
                    menuSettings.setOpenItem(openItem);
                }
                catch (ParseException e) {
                    errorCollector.add(e, Errors.Menu.invalidSetting(config.getSourceFile(), "open-with-item.material"));
                }
            }
        }
        if (settingsSection.contains("auto-refresh")) {
            int refreshTicks = (int)(settingsSection.getDouble("auto-refresh") * 20.0);
            if (refreshTicks < 1) {
                refreshTicks = 1;
            }
            menuSettings.setRefreshTicks(refreshTicks);
        }
        return menuSettings;
    }

    private static void addMenuSettingError(ErrorCollector errorCollector, FileConfig config, String missingSetting, ConfigValueException e) {
        if (e instanceof MissingConfigValueException) {
            errorCollector.add(Errors.Menu.missingSetting(config.getSourceFile(), missingSetting));
        } else {
            errorCollector.add(e, Errors.Menu.invalidSetting(config.getSourceFile(), missingSetting));
        }
    }

    private static List<IconSettings> loadIconSettingsList(FileConfig config, ErrorCollector errorCollector) {
        ArrayList<IconSettings> iconSettingsList = new ArrayList<IconSettings>();
        for (String iconSectionName : config.getKeys()) {
            ConfigSection iconSection;
            if (iconSectionName.equals("menu-settings") || (iconSection = config.getConfigSection(iconSectionName)) == null) continue;
            IconSettings iconSettings = new IconSettings(config.getSourceFile(), iconSectionName);
            iconSettings.loadFrom(iconSection, errorCollector);
            iconSettingsList.add(iconSettings);
        }
        return iconSettingsList;
    }
}

