/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.placeholder;

import java.util.ArrayList;
import java.util.List;
import me.filoghost.chestcommands.api.PlaceholderReplacer;
import me.filoghost.chestcommands.fcommons.Preconditions;
import me.filoghost.chestcommands.fcommons.logging.Log;
import me.filoghost.chestcommands.hook.PlaceholderAPIHook;
import me.filoghost.chestcommands.placeholder.DefaultPlaceholder;
import me.filoghost.chestcommands.placeholder.Placeholder;
import me.filoghost.chestcommands.placeholder.PlaceholderCache;
import me.filoghost.chestcommands.placeholder.PlaceholderRegistry;
import me.filoghost.chestcommands.placeholder.StaticPlaceholder;
import me.filoghost.chestcommands.placeholder.scanner.PlaceholderMatch;
import me.filoghost.chestcommands.placeholder.scanner.PlaceholderScanner;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class PlaceholderManager {
    private static final List<StaticPlaceholder> staticPlaceholders = new ArrayList<StaticPlaceholder>();
    private static final PlaceholderRegistry dynamicPlaceholderRegistry = new PlaceholderRegistry();
    private static final PlaceholderCache placeholderCache = new PlaceholderCache();

    public static boolean hasDynamicPlaceholders(List<String> list) {
        for (String element : list) {
            if (!PlaceholderManager.hasDynamicPlaceholders(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDynamicPlaceholders(String text) {
        if (new PlaceholderScanner(text).containsAny()) {
            return true;
        }
        return PlaceholderAPIHook.INSTANCE.isEnabled() && PlaceholderAPIHook.hasPlaceholders(text);
    }

    public static String replaceDynamicPlaceholders(String text, Player player) {
        text = new PlaceholderScanner(text).replace(match -> PlaceholderManager.getReplacement(match, player));
        if (PlaceholderAPIHook.INSTANCE.isEnabled()) {
            text = PlaceholderAPIHook.setPlaceholders(text, player);
        }
        return text;
    }

    @Nullable
    private static String getReplacement(PlaceholderMatch placeholderMatch, Player player) {
        Placeholder placeholder = dynamicPlaceholderRegistry.getPlaceholder(placeholderMatch);
        if (placeholder == null) {
            return null;
        }
        return placeholderCache.computeIfAbsent(placeholderMatch, player, () -> {
            try {
                return placeholder.getReplacer().getReplacement(player, placeholderMatch.getArgument());
            }
            catch (Throwable t) {
                Log.severe("Encountered an exception while replacing the placeholder \"" + placeholderMatch.getIdentifier() + "\" registered by the plugin \"" + placeholder.getPlugin().getName() + "\"", t);
                return "[PLACEHOLDER ERROR]";
            }
        });
    }

    public static void setStaticPlaceholders(List<StaticPlaceholder> staticPlaceholders) {
        PlaceholderManager.staticPlaceholders.clear();
        PlaceholderManager.staticPlaceholders.addAll(staticPlaceholders);
    }

    public static boolean hasStaticPlaceholders(List<String> list) {
        for (String element : list) {
            if (!PlaceholderManager.hasStaticPlaceholders(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasStaticPlaceholders(String text) {
        for (StaticPlaceholder staticPlaceholder : staticPlaceholders) {
            if (!text.contains(staticPlaceholder.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    public static String replaceStaticPlaceholders(String text) {
        for (StaticPlaceholder staticPlaceholder : staticPlaceholders) {
            text = text.replace(staticPlaceholder.getIdentifier(), staticPlaceholder.getReplacement());
        }
        return text;
    }

    public static void registerPluginPlaceholder(Plugin plugin, String identifier, PlaceholderReplacer placeholderReplacer) {
        Preconditions.notNull(plugin, "plugin");
        PlaceholderManager.checkIdentifierArgument(identifier);
        Preconditions.notNull(placeholderReplacer, "placeholderReplacer");
        dynamicPlaceholderRegistry.registerExternalPlaceholder(plugin, identifier, placeholderReplacer);
    }

    public static boolean unregisterPluginPlaceholder(Plugin plugin, String identifier) {
        Preconditions.notNull(plugin, "plugin");
        PlaceholderManager.checkIdentifierArgument(identifier);
        return dynamicPlaceholderRegistry.unregisterExternalPlaceholder(plugin, identifier);
    }

    private static void checkIdentifierArgument(String identifier) {
        Preconditions.notNull(identifier, "identifier");
        Preconditions.checkArgument(1 <= identifier.length() && identifier.length() <= 30, "identifier length must be between 1 and 30");
        Preconditions.checkArgument(identifier.matches("[a-zA-Z0-9_]+"), "identifier must contain only letters, numbers and underscores");
    }

    public static void onTick() {
        placeholderCache.onTick();
    }

    static {
        for (DefaultPlaceholder placeholder : DefaultPlaceholder.values()) {
            dynamicPlaceholderRegistry.registerInternalPlaceholder(placeholder.getIdentifier(), placeholder.getReplacer());
        }
    }
}

