/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.placeholder;

import java.util.LinkedHashMap;
import java.util.Map;
import me.filoghost.chestcommands.ChestCommands;
import me.filoghost.chestcommands.api.PlaceholderReplacer;
import me.filoghost.chestcommands.fcommons.collection.CaseInsensitiveMap;
import me.filoghost.chestcommands.placeholder.Placeholder;
import me.filoghost.chestcommands.placeholder.scanner.PlaceholderMatch;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class PlaceholderRegistry {
    private final Map<String, Placeholder> internalPlaceholders = new CaseInsensitiveMap<Placeholder>();
    private final Map<String, Map<String, Placeholder>> externalPlaceholders = new CaseInsensitiveMap<Map<String, Placeholder>>();

    public void registerInternalPlaceholder(String identifier, PlaceholderReplacer replacer) {
        this.internalPlaceholders.put(identifier, new Placeholder(ChestCommands.getInstance(), replacer));
    }

    public void registerExternalPlaceholder(Plugin plugin, String identifier, PlaceholderReplacer placeholderReplacer) {
        this.externalPlaceholders.computeIfAbsent(identifier, key -> new CaseInsensitiveMap(new LinkedHashMap())).put(plugin.getName(), new Placeholder(plugin, placeholderReplacer));
    }

    public boolean unregisterExternalPlaceholder(Plugin plugin, String identifier) {
        boolean removed;
        Map<String, Placeholder> externalPlaceholdersByPlugin = this.externalPlaceholders.get(identifier);
        if (externalPlaceholdersByPlugin == null) {
            return false;
        }
        boolean bl = removed = externalPlaceholdersByPlugin.remove(plugin.getName()) != null;
        if (externalPlaceholdersByPlugin.isEmpty()) {
            this.externalPlaceholders.remove(identifier);
        }
        return removed;
    }

    @Nullable
    public Placeholder getPlaceholder(PlaceholderMatch placeholderMatch) {
        Placeholder internalPlaceholder;
        String identifier = placeholderMatch.getIdentifier();
        if (placeholderMatch.getPluginNamespace() == null && (internalPlaceholder = this.internalPlaceholders.get(identifier)) != null) {
            return internalPlaceholder;
        }
        Map<String, Placeholder> externalPlaceholdersByPlugin = this.externalPlaceholders.get(identifier);
        if (externalPlaceholdersByPlugin == null) {
            return null;
        }
        if (placeholderMatch.getPluginNamespace() != null) {
            return externalPlaceholdersByPlugin.get(placeholderMatch.getPluginNamespace());
        }
        if (!externalPlaceholdersByPlugin.isEmpty()) {
            return externalPlaceholdersByPlugin.values().iterator().next();
        }
        return null;
    }
}

