/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.placeholder;

import me.filoghost.chestcommands.placeholder.PlaceholderManager;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class PlaceholderString {
    private final String originalString;
    private final String stringWithStaticPlaceholders;
    private final boolean hasDynamicPlaceholders;

    @Nullable
    public static PlaceholderString of(String string) {
        if (string != null) {
            return new PlaceholderString(string);
        }
        return null;
    }

    private PlaceholderString(String originalString) {
        this.originalString = originalString;
        this.stringWithStaticPlaceholders = PlaceholderManager.replaceStaticPlaceholders(originalString);
        this.hasDynamicPlaceholders = PlaceholderManager.hasDynamicPlaceholders(this.stringWithStaticPlaceholders);
    }

    public String getValue(Player player) {
        if (this.hasDynamicPlaceholders) {
            return PlaceholderManager.replaceDynamicPlaceholders(this.stringWithStaticPlaceholders, player);
        }
        return this.stringWithStaticPlaceholders;
    }

    public String getOriginalValue() {
        return this.originalString;
    }

    public boolean hasDynamicPlaceholders() {
        return this.hasDynamicPlaceholders;
    }
}

