/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.placeholder;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.filoghost.chestcommands.fcommons.Preconditions;
import me.filoghost.chestcommands.fcommons.collection.CollectionUtils;
import me.filoghost.chestcommands.placeholder.PlaceholderManager;
import me.filoghost.chestcommands.placeholder.PlaceholderString;
import org.bukkit.entity.Player;

public class PlaceholderStringList {
    private final ImmutableList<String> originalList;
    private final ImmutableList<String> listWithStaticPlaceholders;
    private final ImmutableList<PlaceholderString> placeholderStringList;
    private final boolean hasDynamicPlaceholders;

    public PlaceholderStringList(List<String> list) {
        Preconditions.notNull(list, "list");
        this.originalList = ImmutableList.copyOf(list);
        this.listWithStaticPlaceholders = PlaceholderManager.hasStaticPlaceholders(this.originalList) ? CollectionUtils.transformImmutable(this.originalList, PlaceholderManager::replaceStaticPlaceholders) : this.originalList;
        this.hasDynamicPlaceholders = PlaceholderManager.hasDynamicPlaceholders(this.listWithStaticPlaceholders);
        this.placeholderStringList = this.hasDynamicPlaceholders ? CollectionUtils.transformImmutable(this.listWithStaticPlaceholders, PlaceholderString::of) : null;
    }

    public ImmutableList<String> getOriginalValue() {
        return this.originalList;
    }

    public ImmutableList<String> getValue(Player player) {
        if (this.hasDynamicPlaceholders) {
            return CollectionUtils.transformImmutable(this.placeholderStringList, element -> element.getValue(player));
        }
        return this.listWithStaticPlaceholders;
    }

    public boolean hasDynamicPlaceholders() {
        return this.hasDynamicPlaceholders;
    }
}

