/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.placeholder.scanner;

import java.util.Objects;
import me.filoghost.chestcommands.fcommons.Strings;

public class PlaceholderMatch {
    private final String pluginNamespace;
    private final String identifier;
    private final String argument;

    private PlaceholderMatch(String pluginNamespace, String identifier, String argument) {
        this.pluginNamespace = pluginNamespace;
        this.identifier = identifier;
        this.argument = argument;
    }

    public String getPluginNamespace() {
        return this.pluginNamespace;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getArgument() {
        return this.argument;
    }

    public static PlaceholderMatch parse(String placeholderContent) {
        String identifier;
        String[] parts;
        String explicitPluginName = null;
        String argument = null;
        if (placeholderContent.contains(":")) {
            parts = Strings.trimmedSplit(placeholderContent, ":", 2);
            identifier = parts[0];
            argument = parts[1];
        } else {
            identifier = placeholderContent;
        }
        if (identifier.contains("/")) {
            parts = Strings.trimmedSplit(identifier, "\\/", 2);
            explicitPluginName = parts[0];
            identifier = parts[1];
        }
        return new PlaceholderMatch(explicitPluginName, identifier, argument);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PlaceholderMatch other = (PlaceholderMatch)obj;
        return Objects.equals(this.pluginNamespace, other.pluginNamespace) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.argument, other.argument);
    }

    public int hashCode() {
        return Objects.hash(this.pluginNamespace, this.identifier, this.argument);
    }
}

