/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.placeholder.scanner;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import me.filoghost.chestcommands.placeholder.scanner.PlaceholderMatch;

public class PlaceholderScanner {
    private final String input;
    private final int inputLength;
    private int lastAppendIndex;
    private int placeholderStartIndex;
    private int index;
    private boolean stopExecution;

    public PlaceholderScanner(String input) {
        this.input = input;
        this.inputLength = input.length();
    }

    public boolean containsAny() {
        AtomicBoolean placeholderFound = new AtomicBoolean(false);
        this.scan(identifier -> {
            this.stopExecution = true;
            placeholderFound.set(true);
        });
        return placeholderFound.get();
    }

    public String replace(Function<PlaceholderMatch, String> replaceFunction) {
        StringBuilder output = new StringBuilder();
        this.scan(identifier -> {
            String replacement = (String)replaceFunction.apply((PlaceholderMatch)identifier);
            if (replacement != null) {
                output.append(this.input, this.lastAppendIndex, this.placeholderStartIndex);
                output.append(replacement);
                this.lastAppendIndex = this.index + 1;
            }
        });
        if (this.lastAppendIndex < this.inputLength) {
            output.append(this.input, this.lastAppendIndex, this.inputLength);
        }
        return output.toString();
    }

    private void scan(Consumer<PlaceholderMatch> matchCallback) {
        this.index = 0;
        this.placeholderStartIndex = 0;
        this.lastAppendIndex = 0;
        boolean insidePlaceholder = false;
        while (this.index < this.inputLength) {
            char currentChar = this.input.charAt(this.index);
            if (insidePlaceholder) {
                if (currentChar == '}') {
                    String placeholderContent = this.input.substring(this.placeholderStartIndex + 1, this.index);
                    matchCallback.accept(PlaceholderMatch.parse(placeholderContent));
                    if (this.stopExecution) {
                        return;
                    }
                    insidePlaceholder = false;
                    this.placeholderStartIndex = 0;
                } else if (currentChar == '{') {
                    this.placeholderStartIndex = this.index;
                }
            } else if (currentChar == '{') {
                insidePlaceholder = true;
                this.placeholderStartIndex = this.index;
            }
            ++this.index;
        }
    }
}

