/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.util.nbt;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import me.filoghost.chestcommands.util.nbt.NBTByte;
import me.filoghost.chestcommands.util.nbt.NBTByteArray;
import me.filoghost.chestcommands.util.nbt.NBTDouble;
import me.filoghost.chestcommands.util.nbt.NBTFloat;
import me.filoghost.chestcommands.util.nbt.NBTInt;
import me.filoghost.chestcommands.util.nbt.NBTIntArray;
import me.filoghost.chestcommands.util.nbt.NBTList;
import me.filoghost.chestcommands.util.nbt.NBTLong;
import me.filoghost.chestcommands.util.nbt.NBTLongArray;
import me.filoghost.chestcommands.util.nbt.NBTShort;
import me.filoghost.chestcommands.util.nbt.NBTString;
import me.filoghost.chestcommands.util.nbt.NBTTag;
import me.filoghost.chestcommands.util.nbt.NBTType;

public final class NBTCompound
extends NBTTag {
    private static final Pattern SIMPLE_STRING = Pattern.compile("[A-Za-z0-9._+-]+");
    private final Map<String, NBTTag> value;

    public NBTCompound(Map<String, NBTTag> value) {
        this.value = new LinkedHashMap<String, NBTTag>(value);
    }

    public NBTCompound() {
        this.value = new LinkedHashMap<String, NBTTag>();
    }

    public int size() {
        return this.value.size();
    }

    @Override
    public Map<String, NBTTag> getValue() {
        return this.value;
    }

    @Override
    public NBTType getType() {
        return NBTType.COMPOUND;
    }

    public NBTTag getTag(String key) {
        if (!this.hasKey(key)) {
            throw new NoSuchElementException(key);
        }
        return this.value.get(key);
    }

    public byte getByte(String key) {
        NBTTag tag = this.value.get(key);
        if (!(tag instanceof NBTByte)) {
            throw new NoSuchElementException(key);
        }
        return ((NBTByte)tag).getValue();
    }

    public short getShort(String key) {
        NBTTag tag = this.value.get(key);
        if (!(tag instanceof NBTShort)) {
            throw new NoSuchElementException(key);
        }
        return ((NBTShort)tag).getValue();
    }

    public int getInt(String key) {
        NBTTag tag = this.value.get(key);
        if (!(tag instanceof NBTInt)) {
            throw new NoSuchElementException(key);
        }
        return ((NBTInt)tag).getValue();
    }

    public long getLong(String key) {
        NBTTag tag = this.value.get(key);
        if (!(tag instanceof NBTLong)) {
            throw new NoSuchElementException(key);
        }
        return ((NBTLong)tag).getValue();
    }

    public float getFloat(String key) {
        NBTTag tag = this.value.get(key);
        if (!(tag instanceof NBTFloat)) {
            throw new NoSuchElementException(key);
        }
        return ((NBTFloat)tag).getValue().floatValue();
    }

    public double getDouble(String key) {
        NBTTag tag = this.value.get(key);
        if (!(tag instanceof NBTDouble)) {
            throw new NoSuchElementException(key);
        }
        return ((NBTDouble)tag).getValue();
    }

    public byte[] getByteArray(String key) {
        NBTTag tag = this.value.get(key);
        if (!(tag instanceof NBTByteArray)) {
            throw new NoSuchElementException(key);
        }
        return ((NBTByteArray)tag).getValue();
    }

    public String getString(String key) {
        NBTTag tag = this.value.get(key);
        if (!(tag instanceof NBTString)) {
            throw new NoSuchElementException(key);
        }
        return ((NBTString)tag).getValue();
    }

    public List<NBTTag> getList(String key) {
        return this.getTagList(key).getValue();
    }

    public NBTList getTagList(String key) {
        NBTTag tag = this.value.get(key);
        if (!(tag instanceof NBTList)) {
            throw new NoSuchElementException(key);
        }
        return (NBTList)tag;
    }

    public Map<String, NBTTag> getCompound(String key) {
        return this.getCompoundTag(key).getValue();
    }

    public NBTCompound getCompoundTag(String key) {
        NBTTag tag = this.value.get(key);
        if (!(tag instanceof NBTCompound)) {
            throw new NoSuchElementException(key);
        }
        return (NBTCompound)tag;
    }

    public int[] getIntArray(String key) {
        NBTTag tag = this.value.get(key);
        if (!(tag instanceof NBTIntArray)) {
            throw new NoSuchElementException(key);
        }
        return ((NBTIntArray)tag).getValue();
    }

    public long[] getLongArray(String key) {
        NBTTag tag = this.value.get(key);
        if (!(tag instanceof NBTLongArray)) {
            throw new NoSuchElementException(key);
        }
        return ((NBTLongArray)tag).getValue();
    }

    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.value.keySet());
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public boolean hasKey(String key) {
        return this.value.containsKey(key);
    }

    public boolean hasKeyOfType(String key, NBTType type) {
        Objects.requireNonNull(type);
        return this.value.containsKey(key) && this.value.get(key).getType() == type;
    }

    public void put(String name, NBTTag tag) {
        this.value.put(name, tag);
    }

    public void putByteArray(String key, byte[] value) {
        this.put(key, new NBTByteArray(value));
    }

    public void putByte(String key, byte value) {
        this.put(key, new NBTByte(value));
    }

    public void putDouble(String key, double value) {
        this.put(key, new NBTDouble(value));
    }

    public void putFloat(String key, float value) {
        this.put(key, new NBTFloat(value));
    }

    public void putIntArray(String key, int[] value) {
        this.put(key, new NBTIntArray(value));
    }

    public void putLongArray(String key, long[] value) {
        this.put(key, new NBTLongArray(value));
    }

    public void putInt(String key, int value) {
        this.put(key, new NBTInt(value));
    }

    public void putLong(String key, long value) {
        this.put(key, new NBTLong(value));
    }

    public void putShort(String key, short value) {
        this.put(key, new NBTShort(value));
    }

    public void putString(String key, String value) {
        this.put(key, new NBTString(value));
    }

    public void forEach(BiConsumer<String, ? super NBTTag> action) {
        this.value.forEach(action);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NBTCompound && this.equals((NBTCompound)obj);
    }

    public boolean equals(NBTCompound tag) {
        return this.isEmpty() && tag.isEmpty() || this.value.equals(tag.value);
    }

    @Override
    public String toMSONString() {
        StringBuilder builder = new StringBuilder("{");
        Set<String> keys = this.value.keySet();
        for (String key : keys) {
            if (builder.length() > 1) {
                builder.append(',');
            }
            builder.append(SIMPLE_STRING.matcher(key).matches() ? key : NBTString.toMSONString(key)).append(':').append(this.value.get(key).toMSONString());
        }
        return builder.append("}").toString();
    }
}

