/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.chestcommands.util.nbt;

import me.filoghost.chestcommands.util.nbt.NBTTag;
import me.filoghost.chestcommands.util.nbt.NBTType;

public final class NBTFloat
extends NBTTag
implements Cloneable {
    private float value;

    public NBTFloat(float value) {
        this.value = value;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    public float getFloatValue() {
        return this.value;
    }

    public void setFloatValue(float value) {
        this.value = value;
    }

    @Override
    public NBTType getType() {
        return NBTType.FLOAT;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NBTFloat && this.equals((NBTFloat)obj);
    }

    public boolean equals(NBTFloat tag) {
        return this.value == tag.value;
    }

    @Override
    public int hashCode() {
        return Float.hashCode(this.value);
    }

    @Override
    public String toMSONString() {
        return this.value + "f";
    }

    public NBTFloat clone() {
        return new NBTFloat(this.value);
    }
}

